/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.scriptbuilder.ScriptBuilder;
import org.jclouds.scriptbuilder.domain.AcceptsStatementVisitor;
import org.jclouds.scriptbuilder.domain.CreateRunScript;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.StatementVisitor;
import org.jclouds.scriptbuilder.domain.Statements;

public class InitScript
extends ForwardingObject
implements Statement,
AcceptsStatementVisitor {
    protected final String instanceName;
    protected final String instanceHome;
    protected final String logDir;
    protected final Map<String, String> exports;
    protected final StatementList init;
    protected final StatementList run;
    protected final ScriptBuilder delegate;

    public static Builder builder() {
        return new Builder();
    }

    protected InitScript(String instanceName, String instanceHome, String logDir, Map<String, String> exports, StatementList init, StatementList run) {
        this.instanceName = Preconditions.checkNotNull(instanceName, "INSTANCE_NAME");
        this.instanceHome = Preconditions.checkNotNull(instanceHome, "INSTANCE_HOME");
        this.logDir = Preconditions.checkNotNull(logDir, "LOG_DIR");
        this.exports = ImmutableMap.copyOf(Preconditions.checkNotNull(exports, "exports"));
        this.init = Preconditions.checkNotNull(init, "init");
        this.run = Preconditions.checkNotNull(run, "run");
        Preconditions.checkArgument(!run.delegate().isEmpty(), "you must specify at least one statement to run");
        this.delegate = InitScript.makeInitScriptStatement(instanceName, instanceHome, logDir, exports, init, run);
    }

    public static ScriptBuilder makeInitScriptStatement(String instanceName, String instanceHome, String logDir, Map<String, String> exports, StatementList init, StatementList run) {
        ImmutableMap<String, String> defaultExports = ImmutableMap.of("INSTANCE_NAME", instanceName, "INSTANCE_HOME", instanceHome, "LOG_DIR", logDir);
        String exitStatusFile = String.format("%s/rc", logDir);
        run = new StatementList(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Statements.interpret("rm -f " + exitStatusFile))).add(Statements.interpret(String.format("trap 'echo $?>%s' 0 1 2 3 15", exitStatusFile)))).addAll((Iterable)run.delegate())).build());
        CreateRunScript createRunScript = Statements.createRunScript(instanceName, Iterables.concat(exports.keySet(), defaultExports.keySet()), "{varl}INSTANCE_HOME{varr}", run);
        return new ScriptBuilder().addEnvironmentVariableScope("default", defaultExports).addEnvironmentVariableScope(instanceName, exports).addStatement(Statements.switchArg(1, new ImmutableMap.Builder<String, Statement>().put("init", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), ScriptBuilder.call(instanceName, new String[0]), init, createRunScript)).put("status", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), ScriptBuilder.findPid("{varl}INSTANCE_NAME{varr}"), Statements.interpret("echo {varl}FOUND_PID{varr}{lf}"))).put("stop", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), ScriptBuilder.findPid("{varl}INSTANCE_NAME{varr}"), Statements.kill())).put("start", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), ScriptBuilder.forget("{varl}INSTANCE_NAME{varr}", "{varl}INSTANCE_HOME{varr}{fs}{varl}INSTANCE_NAME{varr}.{sh}", "{varl}LOG_DIR{varr}"))).put("stdout", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("cat {varl}LOG_DIR{varr}{fs}stdout.log{lf}"))).put("stderr", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("cat {varl}LOG_DIR{varr}{fs}stderr.log{lf}"))).put("exitstatus", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("[ -f $LOG_DIR/rc ] && cat $LOG_DIR/rc"))).put("tail", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("tail {varl}LOG_DIR{varr}{fs}stdout.log{lf}"))).put("tailerr", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("tail {varl}LOG_DIR{varr}{fs}stderr.log{lf}"))).put("run", Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("{varl}INSTANCE_HOME{varr}{fs}{varl}INSTANCE_NAME{varr}.{sh}{lf}"))).build()));
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getInstanceHome() {
        return this.instanceHome;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public StatementList getInitStatement() {
        return this.init;
    }

    public StatementList getRunStatement() {
        return this.init;
    }

    public int hashCode() {
        return Objects.hashCode(this.instanceName);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitScript)) {
            return false;
        }
        InitScript that = (InitScript)obj;
        return Objects.equal(this.instanceName, that.instanceName);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).add("INSTANCE_NAME", this.instanceName).toString();
    }

    @Override
    public void accept(StatementVisitor visitor) {
        this.delegate().accept(visitor);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return this.delegate().functionDependencies(family);
    }

    @Override
    public String render(OsFamily family) {
        return this.delegate().render(family);
    }

    @Override
    protected ScriptBuilder delegate() {
        return this.delegate;
    }

    public static class Builder {
        protected String instanceName;
        protected String instanceHome = "{tmp}{fs}{varl}INSTANCE_NAME{varr}";
        protected String logDir = "{varl}INSTANCE_HOME{varr}";
        protected Map<String, String> exports = ImmutableMap.of();
        protected StatementList init = new StatementList(new Statement[0]);
        protected StatementList run = new StatementList(new Statement[0]);

        public Builder name(String instanceName) {
            this.instanceName = Preconditions.checkNotNull(instanceName, "INSTANCE_NAME");
            return this;
        }

        public Builder home(String instanceHome) {
            this.instanceHome = Preconditions.checkNotNull(instanceHome, "INSTANCE_HOME");
            return this;
        }

        public Builder logDir(String logDir) {
            this.logDir = Preconditions.checkNotNull(logDir, "LOG_DIR");
            return this;
        }

        public Builder exportVariables(Map<String, String> exports) {
            this.exports = ImmutableMap.copyOf(Preconditions.checkNotNull(exports, "exports"));
            return this;
        }

        public Builder run(Statement run) {
            this.run = new StatementList(Preconditions.checkNotNull(run, "run"));
            return this;
        }

        public Builder run(Statement ... run) {
            this.run = new StatementList(Preconditions.checkNotNull(run, "run"));
            return this;
        }

        public Builder run(Iterable<Statement> run) {
            this.run = new StatementList(Preconditions.checkNotNull(run, "run"));
            return this;
        }

        public Builder run(StatementList run) {
            this.run = Preconditions.checkNotNull(run, "run");
            return this;
        }

        public Builder init(Statement init) {
            this.init = new StatementList(Preconditions.checkNotNull(init, "init"));
            return this;
        }

        public Builder init(Statement ... init) {
            this.init = new StatementList(Preconditions.checkNotNull(init, "init"));
            return this;
        }

        public Builder init(Iterable<Statement> init) {
            this.init = new StatementList(Preconditions.checkNotNull(init, "init"));
            return this;
        }

        public Builder init(StatementList init) {
            this.init = Preconditions.checkNotNull(init, "init");
            return this;
        }

        public InitScript build() {
            return new InitScript(this.instanceName, this.instanceHome, this.logDir, this.exports, this.init, this.run);
        }
    }
}

