/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.domain.NetworkAndAddressRange;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.features.FirewallApi;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshKeyPairGenerator;

public final class CreateNodesWithGroupEncodedIntoNameThenAddToSet
extends org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    public static final String EXTERIOR_RANGE = "0.0.0.0/0";
    public static final String DEFAULT_INTERNAL_NETWORK_RANGE = "10.0.0.0/8";
    private final GoogleComputeEngineApi api;
    private final LoadingCache<NetworkAndAddressRange, Network> networkMap;
    private final Predicate<AtomicReference<Operation>> operationDone;
    private final FirewallTagNamingConvention.Factory firewallTagNamingConvention;
    private final SshKeyPairGenerator keyGenerator;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    CreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, GoogleComputeEngineApi api, Predicate<AtomicReference<Operation>> operationDone, LoadingCache<NetworkAndAddressRange, Network> networkMap, FirewallTagNamingConvention.Factory firewallTagNamingConvention, SshKeyPairGenerator keyGenerator) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = api;
        this.operationDone = operationDone;
        this.networkMap = networkMap;
        this.firewallTagNamingConvention = firewallTagNamingConvention;
        this.keyGenerator = keyGenerator;
    }

    @Override
    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        String sharedResourceName = this.namingConvention.create().sharedNameForGroup(group);
        Template mutableTemplate = template.clone();
        GoogleComputeEngineTemplateOptions templateOptions = (GoogleComputeEngineTemplateOptions)GoogleComputeEngineTemplateOptions.class.cast(mutableTemplate.getOptions());
        assert (template.getOptions().equals(templateOptions)) : "options didn't clone properly";
        Network network = this.getOrCreateNetwork(templateOptions, sharedResourceName);
        this.getOrCreateFirewalls(templateOptions, network, this.firewallTagNamingConvention.get(group));
        templateOptions.network(network.selfLink());
        templateOptions.userMetadata("jclouds-group", group);
        if (templateOptions.autoCreateKeyPair() && Strings.isNullOrEmpty(templateOptions.getPublicKey())) {
            this.logger.debug(">> creating default keypair...", new Object[0]);
            Map defaultKeys = (Map)this.keyGenerator.get();
            templateOptions.authorizePublicKey((String)defaultKeys.get("public"));
            templateOptions.overrideLoginPrivateKey((String)defaultKeys.get("private"));
        }
        if (templateOptions.getRunScript() != null && templateOptions.getLoginPrivateKey() == null) {
            this.logger.warn(">> A runScript has been configured but no SSH key has been provided. Authentication will delegate to the ssh-agent", new Object[0]);
        }
        return super.execute(group, count, mutableTemplate, goodNodes, badNodes, customizationResponses);
    }

    private Network getOrCreateNetwork(GoogleComputeEngineTemplateOptions templateOptions, String sharedResourceName) {
        String networkName = templateOptions.network() != null ? CreateNodesWithGroupEncodedIntoNameThenAddToSet.toName(templateOptions.network()) : sharedResourceName;
        return this.networkMap.getUnchecked(NetworkAndAddressRange.create(networkName, DEFAULT_INTERNAL_NETWORK_RANGE, null));
    }

    private void getOrCreateFirewalls(GoogleComputeEngineTemplateOptions templateOptions, Network network, FirewallTagNamingConvention naming) {
        FirewallApi firewallApi = this.api.firewalls();
        ArrayList<AtomicReference<Operation>> operations = Lists.newArrayList();
        int[] arr$ = templateOptions.getInboundPorts();
        int n = arr$.length;
        for (int i$ = 0; i$ < n; ++i$) {
            Integer port = arr$[i$];
            String name = naming.name(port);
            Firewall firewall = firewallApi.get(name);
            if (firewall != null) continue;
            ImmutableList<String> ports = ImmutableList.of(String.valueOf(port));
            ImmutableList<Firewall.Rule> rules = ImmutableList.of(Firewall.Rule.create("tcp", ports), Firewall.Rule.create("udp", ports));
            FirewallOptions firewallOptions = new FirewallOptions().name(name).network(network.selfLink()).allowedRules(rules).sourceTags(templateOptions.getTags()).sourceRanges(ImmutableList.of(DEFAULT_INTERNAL_NETWORK_RANGE, EXTERIOR_RANGE)).targetTags(ImmutableList.of(name));
            AtomicReference<Operation> operation = Atomics.newReference(firewallApi.createInNetwork(firewallOptions.name(), network.selfLink(), firewallOptions));
            operations.add(operation);
        }
        for (AtomicReference atomicReference : operations) {
            this.operationDone.apply(atomicReference);
            Preconditions.checkState(((Operation)atomicReference.get()).httpErrorStatusCode() == null, "Could not insert firewall, operation failed %s", atomicReference);
        }
    }

    private static String toName(URI link) {
        String path = link.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

