/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.jclouds;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import es.bsc.conn.Connector;
import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.jclouds.JCloudsClient;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.VirtualResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.options.TemplateOptions;

public class JClouds
extends Connector {
    private static final String PROP_PROVIDER = "provider";
    private static final String PROP_PROVIDER_USER = "provider-user";
    private static final String PROP_PROVIDER_USER_CRED = "provider-user-credential";
    private static final String PROP_IP_INDEX = "ip-index";
    private static final int SSH_DEFAULT_PORT = 22;
    private static final int MS_TO_S = 1000;
    private static final int MB_TO_GB = 1024;
    private static final long POLLING_INTERVAL = 5L;
    private static final int TIMEOUT = 1800;
    private static final int DEFAULT_IP_INDEX = 0;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors.Conn.JClouds");
    private final String provider;
    private final String providerUser;
    private final String providerUserCred;
    private final int ipIndex;
    private final JCloudsClient jcloudsClient;
    private final Map<String, HardwareDescription> vmidToHardwareRequest = new HashMap<String, HardwareDescription>();
    private final Map<String, SoftwareDescription> vmidToSoftwareRequest = new HashMap<String, SoftwareDescription>();

    public JClouds(Map<String, String> props) throws ConnException {
        super(props);
        this.provider = props.get(PROP_PROVIDER);
        if (this.provider == null) {
            throw new ConnException("Provider must be specified with \"provider\" property");
        }
        this.providerUser = props.get(PROP_PROVIDER_USER);
        if (this.providerUser == null) {
            throw new ConnException("Provider user must be specified with \"provider-user\" property");
        }
        this.providerUserCred = props.get(PROP_PROVIDER_USER_CRED);
        if (this.providerUserCred == null) {
            throw new ConnException("Provider user credential must be specified with \"provider-user-credential\" property");
        }
        String index = props.get(PROP_IP_INDEX);
        this.ipIndex = index != null ? Integer.parseInt(index) : 0;
        try {
            this.jcloudsClient = new JCloudsClient(this.providerUser, this.providerUserCred, this.provider, this.server);
        }
        catch (ConnClientException cce) {
            throw new ConnException("Exception creating client", cce);
        }
    }

    @Override
    public Object create(String requestId, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop) throws ConnException {
        try {
            Template template = this.generateTemplate(hd);
            Set<? extends NodeMetadata> vms = this.jcloudsClient.createVMS(this.appName, 1, template);
            String vmId = vms.iterator().next().getId();
            this.vmidToHardwareRequest.put(vmId, hd);
            this.vmidToSoftwareRequest.put(vmId, sd);
            return vmId;
        }
        catch (IOException | RunNodesException e) {
            throw new ConnException(e);
        }
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        String vmId = (String)id;
        NodeMetadata vmNodeMetadata = this.jcloudsClient.getNode(vmId);
        try {
            LOGGER.info("VM State is " + ((NodeMetadata.Status)((Object)vmNodeMetadata.getStatus())).toString());
            int tries = 0;
            while (vmNodeMetadata.getStatus() == null || !((NodeMetadata.Status)((Object)vmNodeMetadata.getStatus())).equals((Object)NodeMetadata.Status.RUNNING)) {
                if (((NodeMetadata.Status)((Object)vmNodeMetadata.getStatus())).equals((Object)NodeMetadata.Status.ERROR)) {
                    LOGGER.error("Error waiting for VM Creation. Middleware has return an error state");
                    throw new ConnException("Error waiting for VM Creation. Middleware has return an error state");
                }
                if (((NodeMetadata.Status)((Object)vmNodeMetadata.getStatus())).equals((Object)NodeMetadata.Status.SUSPENDED)) {
                    LOGGER.error("VM Creation Suspended");
                    throw new ConnException("VM creation suspended");
                }
                if ((long)tries * 5L > 1800L) {
                    throw new ConnException("Maximum VM creation time reached.");
                }
                ++tries;
                Thread.sleep(5000L);
                vmNodeMetadata = this.jcloudsClient.getNode(vmId);
            }
            String ip = this.getIp(vmNodeMetadata);
            VirtualResource vr = new VirtualResource();
            vr.setId(vmId);
            vr.setIp(ip);
            vr.setProperties(null);
            HardwareDescription hd = this.vmidToHardwareRequest.get(vmId);
            if (hd == null) {
                throw new ConnException("Unregistered hardware description for vmId = " + vmId);
            }
            ArrayList<es.bsc.conn.types.Processor> procs = new ArrayList<es.bsc.conn.types.Processor>();
            int totalCores = 0;
            for (Processor processor : vmNodeMetadata.getHardware().getProcessors()) {
                es.bsc.conn.types.Processor runtimeProc = new es.bsc.conn.types.Processor();
                int pCores = (int)processor.getCores();
                runtimeProc.setComputingUnits((int)processor.getCores());
                runtimeProc.setSpeed((float)processor.getSpeed());
                procs.add(runtimeProc);
                totalCores += pCores;
            }
            hd.setProcessors(procs);
            hd.setTotalComputingUnits(totalCores);
            hd.setMemorySize((float)vmNodeMetadata.getHardware().getRam() / Float.valueOf(1024.0f).floatValue());
            float disk = this.getTotalDisk(vmNodeMetadata.getHardware().getVolumes());
            hd.setStorageSize(disk);
            vr.setHd(hd);
            SoftwareDescription softwareDescription = this.vmidToSoftwareRequest.get(vmId);
            if (softwareDescription == null) {
                throw new ConnException("Unregistered software description for vmId = " + vmId);
            }
            softwareDescription.setOperatingSystemType("Linux");
            vr.setSd(softwareDescription);
            return vr;
        }
        catch (ConnException | InterruptedException e) {
            LOGGER.error("Exception waiting for VM Creation");
            throw new ConnException("Exception waiting for VM Creation", e);
        }
    }

    @Override
    public void destroy(Object id) {
        String vmId = (String)id;
        this.jcloudsClient.destroyNode(vmId);
        this.vmidToHardwareRequest.remove(vmId);
        this.vmidToSoftwareRequest.remove(vmId);
    }

    @Override
    public float getPriceSlot(VirtualResource virtualResource) {
        return virtualResource.getHd().getPricePerUnit();
    }

    @Override
    public void close() {
    }

    private Template generateTemplate(HardwareDescription hd) throws IOException {
        TemplateOptions to = new TemplateOptions();
        String key = this.keypairLoc + this.keypairName;
        LOGGER.debug("Authorizing keys :" + key);
        to.authorizePublicKey(Files.toString(new File(key + ".pub"), Charsets.UTF_8));
        to.overrideLoginPrivateKey(Files.toString(new File(key), Charsets.UTF_8));
        LOGGER.debug("Adding ssh inbound port");
        HashSet<Integer> ports = new HashSet<Integer>();
        ports.add(22);
        int adaptorMaxPort = -1;
        String propAdaptorMaxPort = hd.getImageProperties().get("adaptor-max-port");
        if (propAdaptorMaxPort != null && !propAdaptorMaxPort.isEmpty()) {
            adaptorMaxPort = Integer.parseInt(propAdaptorMaxPort);
        }
        int adaptorMinPort = -1;
        String propAdaptorMinPort = hd.getImageProperties().get("adaptor-min-port");
        if (propAdaptorMinPort != null && !propAdaptorMinPort.isEmpty()) {
            adaptorMinPort = Integer.parseInt(propAdaptorMinPort);
        }
        if (adaptorMaxPort > 0 && adaptorMinPort > 0) {
            for (int port = adaptorMinPort; port < adaptorMaxPort; ++port) {
                LOGGER.debug("Adding inbound port:" + port);
                ports.add(port);
            }
        }
        to.inboundPorts(Ints.toArray(ports));
        LOGGER.debug("Creating template with image " + hd.getImageName());
        return this.jcloudsClient.createTemplate(hd.getImageType(), hd.getImageName(), to);
    }

    private float getTotalDisk(List<? extends Volume> volumes) {
        float totalDisk = 0.0f;
        for (Volume volume : volumes) {
            Float size;
            if (volume == null || (size = volume.getSize()) == null) continue;
            totalDisk += size.floatValue();
        }
        return totalDisk;
    }

    private String getIp(NodeMetadata vmd) throws ConnException {
        if (vmd.getPublicAddresses().isEmpty()) {
            if (vmd.getPrivateAddresses().isEmpty()) {
                throw new ConnException("No addresses found in the node description");
            }
            if (vmd.getPrivateAddresses().size() < this.ipIndex + 1) {
                return vmd.getPrivateAddresses().iterator().next();
            }
            return (String)vmd.getPrivateAddresses().toArray()[this.ipIndex];
        }
        if (vmd.getPublicAddresses().size() < this.ipIndex + 1) {
            return vmd.getPublicAddresses().iterator().next();
        }
        return (String)vmd.getPublicAddresses().toArray()[this.ipIndex];
    }
}

