/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.internal;

import com.google.common.reflect.TypeToken;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackDomainApi;
import org.jclouds.cloudstack.CloudStackGlobalApi;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.Utils;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.location.Provider;
import org.jclouds.rest.ApiContext;

@Singleton
public class CloudStackContextImpl
extends ComputeServiceContextImpl
implements CloudStackContext {
    private final CloudStackApi client;
    private final ApiContext<CloudStackDomainApi> domainContext;
    private final ApiContext<CloudStackGlobalApi> globalContext;

    @Inject
    CloudStackContextImpl(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, ComputeService computeService, Utils utils, CloudStackApi client, ApiContext<CloudStackDomainApi> domainContext, ApiContext<CloudStackGlobalApi> globalContext) {
        super(backend, backendType, computeService, utils);
        this.client = client;
        this.domainContext = domainContext;
        this.globalContext = globalContext;
    }

    @Override
    public CloudStackApi getApi() {
        return this.client;
    }

    @Override
    public CloudStackDomainApi getDomainApi() {
        return this.domainContext.getApi();
    }

    @Override
    public CloudStackGlobalApi getGlobalApi() {
        return this.globalContext.getApi();
    }
}

