/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import org.jclouds.cloudstack.domain.ResourceLimit;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class ResourceLimitToQueryParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof ResourceLimit, "this binder is only valid for ResourceLimit");
        ResourceLimit limit = (ResourceLimit)input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        builder.put("resourcetype", limit.getResourceType().getCode() + "");
        builder.put("account", limit.getAccount());
        builder.put("domainid", limit.getDomainId());
        builder.put("max", limit.getMax() + "");
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParams(builder.build())).build();
    }
}

