/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;

@Singleton
public class TemplateToImage
implements Function<Template, Image> {
    private final Supplier<Set<? extends Location>> locations;
    private final Function<Template, OperatingSystem> templateToOperatingSystem;

    @Inject
    public TemplateToImage(@Memoized Supplier<Set<? extends Location>> locations, Function<Template, OperatingSystem> templateToOperatingSystem) {
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.templateToOperatingSystem = Preconditions.checkNotNull(templateToOperatingSystem, "templateToOperatingSystem");
    }

    @Override
    public Image apply(Template template) {
        Preconditions.checkNotNull(template, "template");
        OperatingSystem os = this.templateToOperatingSystem.apply(template);
        ImageBuilder builder = new ImageBuilder().ids(template.getId() + "").name(template.getName()).description(template.getDisplayText()).operatingSystem(os);
        if (!template.isCrossZones()) {
            builder.location(FluentIterable.from(this.locations.get()).firstMatch(LocationPredicates.idEquals(template.getZoneId())).orNull());
        }
        builder.status(Image.Status.AVAILABLE);
        return builder.build();
    }
}

