/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;

public class AvailabilityZoneInfo
implements Comparable<AvailabilityZoneInfo> {
    private final String zone;
    private final String state;
    private final String region;
    private final Set<String> messages = Sets.newHashSet();

    public AvailabilityZoneInfo(String zone, String zoneState, String region, Iterable<String> messages) {
        this.zone = Preconditions.checkNotNull(zone, "zone");
        this.state = Preconditions.checkNotNull(zoneState, "zoneState");
        this.region = Preconditions.checkNotNull(region, "region");
        Iterables.addAll(this.messages, Preconditions.checkNotNull(messages, "messages"));
    }

    public String getZone() {
        return this.zone;
    }

    public String getState() {
        return this.state;
    }

    public String getRegion() {
        return this.region;
    }

    public Set<String> getMessages() {
        return this.messages;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messages == null ? 0 : this.messages.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.zone == null ? 0 : this.zone.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvailabilityZoneInfo other = (AvailabilityZoneInfo)obj;
        if (this.messages == null ? other.messages != null : !this.messages.equals(other.messages)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return !(this.zone == null ? other.zone != null : !this.zone.equals(other.zone));
    }

    public String toString() {
        return "AvailabilityZoneInfo [messages=" + this.messages + ", region=" + this.region + ", state=" + this.state + ", zone=" + this.zone + "]";
    }

    @Override
    public int compareTo(AvailabilityZoneInfo that) {
        return this.zone.compareTo(that.zone);
    }
}

