/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim.xml;

import com.google.common.base.Splitter;
import java.net.URI;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class VirtualSystemSettingDataHandler
extends ParseSax.HandlerWithResult<VirtualSystemSettingData> {
    protected StringBuilder currentText = new StringBuilder();
    protected VirtualSystemSettingData.Builder builder = VirtualSystemSettingData.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualSystemSettingData getResult() {
        try {
            VirtualSystemSettingData virtualSystemSettingData = this.builder.build();
            return virtualSystemSettingData;
        }
        finally {
            this.builder = VirtualSystemSettingData.builder();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String current = SaxUtils.currentOrNull(this.currentText);
        if (current != null) {
            if (SaxUtils.equalsOrSuffix(qName, "ElementName")) {
                this.builder.elementName(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "InstanceID")) {
                this.builder.instanceID(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Caption")) {
                this.builder.caption(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Description")) {
                this.builder.description(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "AutomaticRecoveryAction")) {
                this.builder.automaticRecoveryAction(VirtualSystemSettingData.AutomaticRecoveryAction.fromValue(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "AutomaticShutdownAction")) {
                this.builder.automaticShutdownAction(VirtualSystemSettingData.AutomaticShutdownAction.fromValue(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "AutomaticStartupAction")) {
                this.builder.automaticStartupAction(VirtualSystemSettingData.AutomaticStartupAction.fromValue(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "AutomaticStartupActionDelay")) {
                this.builder.automaticStartupActionDelay(null);
            } else if (SaxUtils.equalsOrSuffix(qName, "AutomaticStartupActionSequenceNumber")) {
                this.builder.automaticStartupActionSequenceNumber(Integer.valueOf(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "ConfigurationDataRoot")) {
                this.builder.configurationDataRoot(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "ConfigurationFile")) {
                this.builder.configurationFile(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "ConfigurationID")) {
                this.builder.configurationID(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "CreationTime")) {
                this.builder.creationTime(null);
            } else if (SaxUtils.equalsOrSuffix(qName, "LogDataRoot")) {
                this.builder.logDataRoot(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "RecoveryFile")) {
                this.builder.recoveryFile(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "RecoveryFile")) {
                this.builder.recoveryFile(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "SuspendDataRoot")) {
                this.builder.suspendDataRoot(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "SwapFileDataRoot")) {
                this.builder.swapFileDataRoot(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "VirtualSystemIdentifier")) {
                this.builder.virtualSystemIdentifier(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "VirtualSystemType")) {
                this.builder.virtualSystemTypes(Splitter.on(',').trimResults().omitEmptyStrings().split(current));
            } else if (SaxUtils.equalsOrSuffix(qName, "Notes")) {
                this.builder.notes(current);
            }
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

