/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.config;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.concurrent.TimeUnit;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.CloudStackDomainApi;
import org.jclouds.cloudstack.CloudStackGlobalApi;
import org.jclouds.cloudstack.config.CredentialType;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.features.SessionApi;
import org.jclouds.cloudstack.filters.AddSessionKeyAndJSessionIdToRequest;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.cloudstack.handlers.CloudStackErrorHandler;
import org.jclouds.cloudstack.handlers.InvalidateSessionAndRetryOn401AndLogoutOnClose;
import org.jclouds.cloudstack.loaders.LoginWithPasswordCredentials;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.OnlyLocationOrFirstZone;
import org.jclouds.rest.ApiContext;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.internal.ApiContextImpl;

@ConfiguresHttpApi
public class CloudStackHttpApiModule
extends HttpApiModule<CloudStackApi> {
    @Override
    protected void configure() {
        this.bind(new TypeLiteral<ApiContext<CloudStackDomainApi>>(){}).to((TypeLiteral<ApiContext<CloudStackDomainApi>>)new TypeLiteral<ApiContextImpl<CloudStackDomainApi>>(){});
        this.bind(new TypeLiteral<ApiContext<CloudStackGlobalApi>>(){}).to((TypeLiteral<ApiContext<CloudStackGlobalApi>>)new TypeLiteral<ApiContextImpl<CloudStackGlobalApi>>(){});
        this.bind(CredentialType.class).toProvider(CredentialTypeFromPropertyOrDefault.class);
        BinderUtils.bindHttpApi(this.binder(), SessionApi.class);
        BinderUtils.bindHttpApi(this.binder(), CloudStackDomainApi.class);
        BinderUtils.bindHttpApi(this.binder(), CloudStackGlobalApi.class);
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(InvalidateSessionAndRetryOn401AndLogoutOnClose.class);
        super.configure();
    }

    @Override
    protected void installLocations() {
        super.installLocations();
        this.bind(ImplicitLocationSupplier.class).to(OnlyLocationOrFirstZone.class).in(Scopes.SINGLETON);
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(CloudStackErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(CloudStackErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(CloudStackErrorHandler.class);
    }

    @Provides
    @Singleton
    protected AuthenticationFilter authenticationFilterForCredentialType(CredentialType credentialType, AddSessionKeyAndJSessionIdToRequest addSessionKeyAndJSessionIdToRequest, QuerySigner querySigner) {
        switch (credentialType) {
            case PASSWORD_CREDENTIALS: {
                return addSessionKeyAndJSessionIdToRequest;
            }
            case API_ACCESS_KEY_CREDENTIALS: {
                return querySigner;
            }
        }
        throw new IllegalArgumentException("credential type not supported: " + (Object)((Object)credentialType));
    }

    @Provides
    @Singleton
    protected LoadingCache<Credentials, LoginResponse> provideLoginResponseCache(LoginWithPasswordCredentials getLoginResponse, @Named(value="jclouds.session-interval") int seconds) {
        return CacheBuilder.newBuilder().expireAfterWrite(seconds, TimeUnit.SECONDS).build(getLoginResponse);
    }

    @Provides
    @Singleton
    protected Supplier<LoginResponse> provideLoginResponseSupplier(final LoadingCache<Credentials, LoginResponse> cache, final @Provider Supplier<Credentials> creds) {
        return new Supplier<LoginResponse>(){

            @Override
            public LoginResponse get() {
                return (LoginResponse)cache.getUnchecked(creds.get());
            }
        };
    }

    @Singleton
    static class CredentialTypeFromPropertyOrDefault
    implements javax.inject.Provider<CredentialType> {
        @Inject(optional=true)
        @Named(value="jclouds.cloudstack.credential-type")
        String credentialType = CredentialType.API_ACCESS_KEY_CREDENTIALS.toString();

        CredentialTypeFromPropertyOrDefault() {
        }

        @Override
        public CredentialType get() {
            return CredentialType.fromValue(this.credentialType);
        }
    }
}

