/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Option
implements Comparable<Option> {
    private final Long id;
    private final String name;
    private final String description;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromOption(this);
    }

    public static Option createWithIdNameAndDescription(Long id, String name, String description) {
        return new Option(id, name, description);
    }

    @ConstructorProperties(value={"id", "name", "description"})
    protected Option(Long id, String name, @Nullable String description) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name");
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.description);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Option that = (Option)Option.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("name", this.name).add("description", this.description);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Option o) {
        return Longs.compare(this.id, o.id);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Long id;
        protected String name;
        protected String description;

        protected abstract T self();

        public T id(Long id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public Option build() {
            return new Option(this.id, this.name, this.description);
        }

        public T fromOption(Option in) {
            return ((Builder)((Builder)this.id(in.getId())).name(in.getName())).description(in.getDescription());
        }
    }
}

