/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.net.URI;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.UrlMap;
import org.jclouds.googlecomputeengine.domain.UrlMapValidateResult;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.googlecomputeengine.options.UrlMapOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface UrlMapApi {
    @Named(value="UrlMaps:get")
    @GET
    @Path(value="/{urlMap}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public UrlMap get(@PathParam(value="urlMap") String var1);

    @Named(value="UrlMaps:insert")
    @POST
    @Produces(value={"application/json"})
    public Operation create(@BinderParam(value=BindToJsonPayload.class) UrlMapOptions var1);

    @Named(value="UrlMaps:insert")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation create(@PayloadParam(value="name") String var1, @PayloadParam(value="defaultService") URI var2);

    @Named(value="UrlMaps:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{urlMap}")
    public Operation update(@PathParam(value="urlMap") String var1, @BinderParam(value=BindToJsonPayload.class) UrlMapOptions var2);

    @Named(value="UrlMaps:patch")
    @PATCH
    @Produces(value={"application/json"})
    @Path(value="/{urlMap}")
    public Operation patch(@PathParam(value="urlMap") String var1, @BinderParam(value=BindToJsonPayload.class) UrlMapOptions var2);

    @Named(value="UrlMaps:delete")
    @DELETE
    @Path(value="/{urlMap}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation delete(@PathParam(value="urlMap") String var1);

    @Named(value="UrlMaps:validate")
    @POST
    @Path(value="/{urlMap}/validate")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    @MapBinder(value=BindToJsonPayload.class)
    public UrlMapValidateResult validate(@PathParam(value="urlMap") String var1, @PayloadParam(value="resource") UrlMapOptions var2);

    @Named(value="UrlMaps:validate")
    @POST
    @Path(value="/{urlMap}/validate")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    @MapBinder(value=BindToJsonPayload.class)
    public UrlMapValidateResult validate(@PathParam(value="urlMap") String var1, @PayloadParam(value="resource") UrlMap var2);

    @Named(value="UrlMaps:list")
    @GET
    public ListPage<UrlMap> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="UrlMaps:list")
    @GET
    @Transform(value=UrlMapPages.class)
    public Iterator<ListPage<UrlMap>> list();

    @Named(value="UrlMaps:list")
    @GET
    @Transform(value=UrlMapPages.class)
    public Iterator<ListPage<UrlMap>> list(ListOptions var1);

    public static final class UrlMapPages
    extends BaseToIteratorOfListPage<UrlMap, UrlMapPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        UrlMapPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<UrlMap>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<UrlMap>>(){

                @Override
                public ListPage<UrlMap> apply(String pageToken) {
                    return UrlMapPages.this.api.urlMaps().listPage(pageToken, options);
                }
            };
        }
    }
}

