/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.net.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;

@Beta
public enum IpProtocol {
    TCP,
    UDP,
    ICMP,
    ALL,
    UNRECOGNIZED;


    public String value() {
        return this == ALL ? "-1" : this.name().toLowerCase();
    }

    public String toString() {
        return this.value();
    }

    public static IpProtocol fromValue(String protocol) {
        try {
            if (protocol.equalsIgnoreCase("-1")) {
                return ALL;
            }
            return IpProtocol.valueOf(Preconditions.checkNotNull(protocol, "protocol").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

