/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

@Beta
public class Sudoers
implements Statement {
    private static final String sudoers = "/etc/sudoers";

    @Override
    public String render(OsFamily family) {
        Preconditions.checkNotNull(family, "family");
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add(Statements.createOrOverwriteFile(sudoers, ImmutableSet.of("root ALL = (ALL) ALL", "%wheel ALL = (ALL) NOPASSWD:ALL")));
        statements.add(Statements.exec("chmod 0440 /etc/sudoers"));
        return new StatementList(statements.build()).render(family);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }
}

