/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Set;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;

public class SecurityGroupPredicates {
    public static Predicate<SecurityGroup> nameEquals(final String name) {
        Preconditions.checkNotNull(name, "name must be defined");
        return new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup ext) {
                return name.equals(ext.getName());
            }

            public String toString() {
                return "nameEquals(" + name + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> nameIn(final Set<String> names) {
        Preconditions.checkNotNull(names, "names must be defined");
        return new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup ext) {
                return Predicates.in(names).apply(ext.getName());
            }

            public String toString() {
                return "nameIn(" + names + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> nameMatches(final Predicate<String> name) {
        Preconditions.checkNotNull(name, "name must be defined");
        return new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup ext) {
                return name.apply(ext.getName());
            }

            public String toString() {
                return "nameMatches(" + name + ")";
            }
        };
    }

    public static Predicate<SecurityGroupRule> ruleCidr(final String cidr) {
        Preconditions.checkNotNull(cidr, "cidr must be defined");
        return new Predicate<SecurityGroupRule>(){

            @Override
            public boolean apply(SecurityGroupRule ext) {
                return cidr.equals(ext.getIpRange());
            }

            public String toString() {
                return "cidr(" + cidr + ")";
            }
        };
    }

    public static Predicate<SecurityGroupRule> ruleGroup(final String groupName) {
        Preconditions.checkNotNull(groupName, "groupName must be defined");
        return new Predicate<SecurityGroupRule>(){

            @Override
            public boolean apply(SecurityGroupRule ext) {
                return ext.getGroup() != null && groupName.equals(ext.getGroup().getName());
            }

            public String toString() {
                return "ruleGroup(" + groupName + ")";
            }
        };
    }

    public static Predicate<SecurityGroupRule> ruleProtocol(final IpProtocol protocol) {
        Preconditions.checkNotNull(protocol, "protocol must be defined");
        return new Predicate<SecurityGroupRule>(){

            @Override
            public boolean apply(SecurityGroupRule ext) {
                return protocol.equals((Object)ext.getIpProtocol());
            }

            public String toString() {
                return "ruleProtocol(" + (Object)((Object)protocol) + ")";
            }
        };
    }

    public static Predicate<SecurityGroupRule> ruleStartPort(final int startPort) {
        Preconditions.checkNotNull(startPort, "startPort must be defined");
        return new Predicate<SecurityGroupRule>(){

            @Override
            public boolean apply(SecurityGroupRule ext) {
                return startPort == ext.getFromPort();
            }

            public String toString() {
                return "ruleStartPort(" + startPort + ")";
            }
        };
    }

    public static Predicate<SecurityGroupRule> ruleEndPort(final int endPort) {
        Preconditions.checkNotNull(endPort, "endPort must be defined");
        return new Predicate<SecurityGroupRule>(){

            @Override
            public boolean apply(SecurityGroupRule ext) {
                return endPort == ext.getToPort();
            }

            public String toString() {
                return "ruleEndPort(" + endPort + ")";
            }
        };
    }
}

