/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.VirtualGuest;

public class ContainerVirtualGuestConfigurationOption {
    @Named(value="itemPrice")
    private final ProductItemPrice productItemPrice;
    private final VirtualGuest template;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ContainerVirtualGuestConfigurationOption.builder().fromContainerVirtualGuestConfigurationOption(this);
    }

    @ConstructorProperties(value={"itemPrice", "template"})
    public ContainerVirtualGuestConfigurationOption(@Nullable ProductItemPrice productItemPrice, VirtualGuest template) {
        this.productItemPrice = productItemPrice;
        this.template = Preconditions.checkNotNull(template, "template");
    }

    public ProductItemPrice getProductItemPrice() {
        return this.productItemPrice;
    }

    public VirtualGuest getTemplate() {
        return this.template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerVirtualGuestConfigurationOption that = (ContainerVirtualGuestConfigurationOption)o;
        return Objects.equal(this.productItemPrice, that.productItemPrice) && Objects.equal(this.template, that.template);
    }

    public int hashCode() {
        return Objects.hashCode(this.productItemPrice, this.template);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("productItemPrice", this.productItemPrice).add("template", this.template).toString();
    }

    public static class Builder {
        protected ProductItemPrice productItemPrice;
        protected VirtualGuest template;

        public Builder productItemPrice(ProductItemPrice productItemPrice) {
            this.productItemPrice = productItemPrice;
            return this;
        }

        public Builder template(VirtualGuest template) {
            this.template = template;
            return this;
        }

        public ContainerVirtualGuestConfigurationOption build() {
            return new ContainerVirtualGuestConfigurationOption(this.productItemPrice, this.template);
        }

        public Builder fromContainerVirtualGuestConfigurationOption(ContainerVirtualGuestConfigurationOption in) {
            return this.productItemPrice(in.getProductItemPrice()).template(in.getTemplate());
        }
    }
}

