/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.schmizz.concurrent.ExceptionChainer;
import net.schmizz.concurrent.Promise;

public class Event<T extends Throwable> {
    private static final Object SOME = new Object(){

        public String toString() {
            return "SOME";
        }
    };
    private final Promise<Object, T> promise;

    public Event(String name, ExceptionChainer<T> chainer) {
        this.promise = new Promise(name, chainer);
    }

    public Event(String name, ExceptionChainer<T> chainer, ReentrantLock lock) {
        this.promise = new Promise(name, chainer, lock);
    }

    public void set() {
        this.promise.deliver(SOME);
    }

    public void clear() {
        this.promise.clear();
    }

    public void deliverError(Throwable t) {
        this.promise.deliverError(t);
    }

    public boolean isSet() {
        return this.promise.isDelivered();
    }

    public void await() throws T {
        this.promise.retrieve();
    }

    public void await(long timeout, TimeUnit unit) throws T {
        this.promise.retrieve(timeout, unit);
    }

    public boolean tryAwait(long timeout, TimeUnit unit) throws T {
        return this.promise.tryRetrieve(timeout, unit) != null;
    }

    public boolean hasWaiters() {
        return this.promise.hasWaiters();
    }

    public boolean inError() {
        return this.promise.inError();
    }

    public void lock() {
        this.promise.lock();
    }

    public void unlock() {
        this.promise.unlock();
    }

    public String toString() {
        return this.promise.toString();
    }
}

