/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;

@Singleton
public class ComputeUtils {
    private final CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory;
    private final ListeningExecutorService userExecutor;

    @Inject
    public ComputeUtils(CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory = customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory;
        this.userExecutor = userExecutor;
    }

    public Map<?, ListenableFuture<Void>> customizeNodesAndAddToGoodMapOrPutExceptionIntoBadMap(TemplateOptions options, Iterable<NodeMetadata> runningNodes, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        LinkedHashMap<NodeMetadata, ListenableFuture<Void>> responses = Maps.newLinkedHashMap();
        for (NodeMetadata node : runningNodes) {
            responses.put(node, this.userExecutor.submit(this.customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory.create(options, new AtomicReference<NodeMetadata>(node), goodNodes, badNodes, customizationResponses)));
        }
        return responses;
    }
}

