/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.Statement;

public class JoyentCloudTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected Optional<Boolean> generateKey = Optional.absent();

    @Override
    public JoyentCloudTemplateOptions clone() {
        JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
        this.copyTo(options);
        return options;
    }

    @Override
    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof JoyentCloudTemplateOptions) {
            JoyentCloudTemplateOptions eTo = (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(to);
            eTo.generateKey = this.generateKey;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoyentCloudTemplateOptions that = (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(o);
        return super.equals(that) && Objects.equal(this.generateKey, that.generateKey);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.generateKey);
    }

    @Override
    public Objects.ToStringHelper string() {
        return super.string().add("generateKey", this.generateKey.orNull());
    }

    public JoyentCloudTemplateOptions generateKey(boolean enable) {
        this.generateKey = Optional.of(enable);
        return this;
    }

    public Optional<Boolean> shouldGenerateKey() {
        return this.generateKey;
    }

    @Override
    public JoyentCloudTemplateOptions blockOnPort(int port, int seconds) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public JoyentCloudTemplateOptions inboundPorts(int ... ports) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    @Override
    public JoyentCloudTemplateOptions authorizePublicKey(String publicKey) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    @Override
    public JoyentCloudTemplateOptions installPrivateKey(String privateKey) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Override
    public JoyentCloudTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    @Override
    public JoyentCloudTemplateOptions dontAuthorizePublicKey() {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    @Override
    public JoyentCloudTemplateOptions nameTask(String name) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public JoyentCloudTemplateOptions runAsRoot(boolean runAsRoot) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public JoyentCloudTemplateOptions runScript(Statement script) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.runScript(script));
    }

    @Override
    public JoyentCloudTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    @Override
    public JoyentCloudTemplateOptions overrideLoginPassword(String password) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    @Override
    public JoyentCloudTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    @Override
    public JoyentCloudTemplateOptions overrideLoginUser(String loginUser) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    @Override
    public JoyentCloudTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    @Override
    public JoyentCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    @Override
    public JoyentCloudTemplateOptions userMetadata(String key, String value) {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public static class Builder {
        public static JoyentCloudTemplateOptions generateKey(boolean enable) {
            return new JoyentCloudTemplateOptions().generateKey(enable);
        }

        public static JoyentCloudTemplateOptions inboundPorts(int ... ports) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static JoyentCloudTemplateOptions blockOnPort(int port, int seconds) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static JoyentCloudTemplateOptions installPrivateKey(String rsaKey) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static JoyentCloudTemplateOptions authorizePublicKey(String rsaKey) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static JoyentCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static JoyentCloudTemplateOptions overrideLoginUser(String user) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static JoyentCloudTemplateOptions overrideLoginPassword(String password) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static JoyentCloudTemplateOptions overrideLoginPrivateKey(String privateKey) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static JoyentCloudTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static JoyentCloudTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static JoyentCloudTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            JoyentCloudTemplateOptions options = new JoyentCloudTemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }
    }
}

