/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.Configuration;
import org.jclouds.ovf.DeploymentOptionSection;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DeploymentOptionSectionHandler
extends SectionHandler<DeploymentOptionSection, DeploymentOptionSection.Builder> {
    protected Configuration.Builder configBuilder = Configuration.builder();

    @Inject
    public DeploymentOptionSectionHandler(Provider<DeploymentOptionSection.Builder> builderProvider) {
        super(builderProvider);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "Configuration")) {
            this.configBuilder.id(attributes.get("id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "Info")) {
            ((DeploymentOptionSection.Builder)this.builder).info(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Label")) {
            this.configBuilder.label(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Description")) {
            this.configBuilder.description(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Configuration")) {
            try {
                ((DeploymentOptionSection.Builder)this.builder).configuration(this.configBuilder.build());
            }
            finally {
                this.configBuilder = Configuration.builder();
            }
        }
        super.endElement(uri, localName, qName);
    }
}

