/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.softlayer.domain.ProductItem;

public class ProductItemPrice {
    private final int id;
    private final float hourlyRecurringFee;
    private final String recurringFee;
    private final ProductItem item;

    @ConstructorProperties(value={"id", "hourlyRecurringFee", "recurringFee", "item"})
    public ProductItemPrice(int id, float hourlyRecurringFee, String recurringFee, ProductItem item) {
        this.id = id;
        this.hourlyRecurringFee = hourlyRecurringFee;
        this.recurringFee = Preconditions.checkNotNull(recurringFee, "recurringFee");
        this.item = Preconditions.checkNotNull(item, "item");
    }

    public int getId() {
        return this.id;
    }

    public float getHourlyRecurringFee() {
        return this.hourlyRecurringFee;
    }

    public String getRecurringFee() {
        return this.recurringFee;
    }

    public ProductItem getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductItemPrice that = (ProductItemPrice)o;
        return Objects.equal(this.id, that.id) && Objects.equal(Float.valueOf(this.hourlyRecurringFee), Float.valueOf(that.hourlyRecurringFee)) && Objects.equal(this.recurringFee, that.recurringFee) && Objects.equal(this.item, that.item);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, Float.valueOf(this.hourlyRecurringFee), this.recurringFee, this.item);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("id", this.id).add("hourlyRecurringFee", this.hourlyRecurringFee).add("recurringFee", this.recurringFee).add("item", this.item).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ProductItemPrice.builder().fromProductItemPrice(this);
    }

    public static class Builder {
        private int id;
        private float hourlyRecurringFee;
        private String recurringFee;
        private ProductItem item;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder hourlyRecurringFee(float hourlyRecurringFee) {
            this.hourlyRecurringFee = hourlyRecurringFee;
            return this;
        }

        public Builder recurringFee(String recurringFee) {
            this.recurringFee = recurringFee;
            return this;
        }

        public Builder item(ProductItem item) {
            this.item = item;
            return this;
        }

        public ProductItemPrice build() {
            return new ProductItemPrice(this.id, this.hourlyRecurringFee, this.recurringFee, this.item);
        }

        public Builder fromProductItemPrice(ProductItemPrice in) {
            return this.id(in.getId()).hourlyRecurringFee(in.getHourlyRecurringFee()).recurringFee(in.getRecurringFee()).item(in.getItem());
        }
    }
}

