/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.softlayer.domain.VirtualDiskImage;

public class VirtualGuestBlockDeviceTemplate {
    private final int id;
    private final String device;
    private final int diskImageId;
    private final float diskSpace;
    private final int groupId;
    private final String units;
    private final VirtualDiskImage diskImage;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VirtualGuestBlockDeviceTemplate.builder().fromVirtualGuestBlockDeviceTemplate(this);
    }

    @ConstructorProperties(value={"id", "device", "diskImageId", "diskSpace", "groupId", "units", "diskImage"})
    protected VirtualGuestBlockDeviceTemplate(int id, String device, int diskImageId, float diskSpace, int groupId, String units, VirtualDiskImage diskImage) {
        this.id = id;
        this.device = Preconditions.checkNotNull(device, "device");
        this.diskImageId = diskImageId;
        this.diskSpace = diskSpace;
        this.groupId = groupId;
        this.units = units;
        this.diskImage = Preconditions.checkNotNull(diskImage, "diskImage");
    }

    public int getId() {
        return this.id;
    }

    public String getDevice() {
        return this.device;
    }

    public int getDiskImageId() {
        return this.diskImageId;
    }

    public float getDiskSpace() {
        return this.diskSpace;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getUnits() {
        return this.units;
    }

    public VirtualDiskImage getDiskImage() {
        return this.diskImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualGuestBlockDeviceTemplate that = (VirtualGuestBlockDeviceTemplate)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.device, that.device) && Objects.equal(this.diskImageId, that.diskImageId) && Objects.equal(Float.valueOf(this.diskSpace), Float.valueOf(that.diskSpace)) && Objects.equal(this.groupId, that.groupId) && Objects.equal(this.units, that.units) && Objects.equal(this.diskImage, that.diskImage);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.device, this.diskImageId, Float.valueOf(this.diskSpace), this.groupId, this.units, this.diskImage);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("id", this.id).add("device", this.device).add("diskImageId", this.diskImageId).add("diskSpace", this.diskSpace).add("groupId", this.groupId).add("units", this.units).add("diskImage", this.diskImage).toString();
    }

    public static class Builder {
        protected int id;
        protected String device;
        protected int diskImageId;
        protected float diskSpace;
        protected int groupId;
        protected String units;
        protected VirtualDiskImage diskImage;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder device(String device) {
            this.device = device;
            return this;
        }

        public Builder diskImageId(int diskImageId) {
            this.diskImageId = diskImageId;
            return this;
        }

        public Builder diskSpace(float diskSpace) {
            this.diskSpace = diskSpace;
            return this;
        }

        public Builder groupId(int groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder units(String units) {
            this.units = units;
            return this;
        }

        public Builder diskImage(VirtualDiskImage diskImage) {
            this.diskImage = diskImage;
            return this;
        }

        public VirtualGuestBlockDeviceTemplate build() {
            return new VirtualGuestBlockDeviceTemplate(this.id, this.device, this.diskImageId, this.diskSpace, this.groupId, this.units, this.diskImage);
        }

        public Builder fromVirtualGuestBlockDeviceTemplate(VirtualGuestBlockDeviceTemplate in) {
            return this.id(in.getId()).device(in.getDevice()).diskImageId(in.getDiskImageId()).diskSpace(in.getDiskSpace()).groupId(in.getGroupId()).units(in.getUnits()).diskImage(in.getDiskImage());
        }
    }
}

