/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.gogrid.domain.JobProperties;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.ObjectType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.javax.annotation.Nullable;

public class Job
implements Comparable<Job> {
    private final long id;
    private final Option command;
    private final ObjectType objectType;
    private final Date createdOn;
    private final Date lastUpdatedOn;
    private final JobState currentState;
    private final int attempts;
    private final String owner;
    private final Set<JobProperties> history;
    private final Map<String, String> details;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromJob(this);
    }

    @ConstructorProperties(value={"id", "command", "objecttype", "createdon", "lastupdatedon", "currentstate", "attempts", "owner", "history", "detail"})
    protected Job(long id, Option command, ObjectType objectType, Date createdOn, @Nullable Date lastUpdatedOn, JobState currentState, int attempts, String owner, Set<JobProperties> history, Map<String, String> details) {
        this.id = id;
        this.command = Preconditions.checkNotNull(command, "command");
        this.objectType = Preconditions.checkNotNull(objectType, "objectType");
        this.createdOn = Preconditions.checkNotNull(createdOn, "createdOn");
        this.lastUpdatedOn = lastUpdatedOn;
        this.currentState = Preconditions.checkNotNull(currentState, "currentState");
        this.attempts = attempts;
        this.owner = Preconditions.checkNotNull(owner, "owner");
        this.history = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(history, "history"));
        this.details = ImmutableMap.copyOf(Preconditions.checkNotNull(details, "details"));
    }

    public long getId() {
        return this.id;
    }

    public Option getCommand() {
        return this.command;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    @Nullable
    public Date getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public JobState getCurrentState() {
        return this.currentState;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public String getOwner() {
        return this.owner;
    }

    public Set<JobProperties> getHistory() {
        return this.history;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.command, this.objectType, this.createdOn, this.lastUpdatedOn, this.currentState, this.attempts, this.owner, this.history, this.details});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Job that = (Job)Job.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.command, that.command) && Objects.equal((Object)this.objectType, (Object)that.objectType) && Objects.equal(this.createdOn, that.createdOn) && Objects.equal(this.lastUpdatedOn, that.lastUpdatedOn) && Objects.equal((Object)this.currentState, (Object)that.currentState) && Objects.equal(this.attempts, that.attempts) && Objects.equal(this.owner, that.owner) && Objects.equal(this.history, that.history) && Objects.equal(this.details, that.details);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("command", this.command).add("objectType", (Object)this.objectType).add("createdOn", this.createdOn).add("lastUpdatedOn", this.lastUpdatedOn).add("currentState", (Object)this.currentState).add("attempts", this.attempts).add("owner", this.owner).add("history", this.history).add("details", this.details);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Job o) {
        if (this.createdOn != null && o.getCreatedOn() != null) {
            return Longs.compare(this.createdOn.getTime(), o.getCreatedOn().getTime());
        }
        return Longs.compare(this.id, o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long id;
        protected Option command;
        protected ObjectType objectType;
        protected Date createdOn;
        protected Date lastUpdatedOn;
        protected JobState currentState;
        protected int attempts;
        protected String owner;
        protected Set<JobProperties> history = ImmutableSet.of();
        protected Map<String, String> details = ImmutableMap.of();

        protected abstract T self();

        public T id(long id) {
            this.id = id;
            return this.self();
        }

        public T command(Option command) {
            this.command = command;
            return this.self();
        }

        public T objectType(ObjectType objectType) {
            this.objectType = objectType;
            return this.self();
        }

        public T createdOn(Date createdOn) {
            this.createdOn = createdOn;
            return this.self();
        }

        public T lastUpdatedOn(Date lastUpdatedOn) {
            this.lastUpdatedOn = lastUpdatedOn;
            return this.self();
        }

        public T currentState(JobState currentState) {
            this.currentState = currentState;
            return this.self();
        }

        public T attempts(int attempts) {
            this.attempts = attempts;
            return this.self();
        }

        public T owner(String owner) {
            this.owner = owner;
            return this.self();
        }

        public T history(Set<JobProperties> history) {
            this.history = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(history, "history"));
            return this.self();
        }

        public T history(JobProperties ... in) {
            return this.history(ImmutableSet.copyOf(in));
        }

        public T details(Map<String, String> details) {
            this.details = ImmutableMap.copyOf(Preconditions.checkNotNull(details, "details"));
            return this.self();
        }

        public Job build() {
            return new Job(this.id, this.command, this.objectType, this.createdOn, this.lastUpdatedOn, this.currentState, this.attempts, this.owner, this.history, this.details);
        }

        public T fromJob(Job in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).command(in.getCommand())).objectType(in.getObjectType())).createdOn(in.getCreatedOn())).lastUpdatedOn(in.getLastUpdatedOn())).currentState(in.getCurrentState())).attempts(in.getAttempts())).owner(in.getOwner())).history(in.getHistory())).details(in.getDetails());
        }
    }
}

