/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.date.DateService;

@Singleton
public class DateParser
implements Function<Object, String> {
    private final DateService dateService;

    @Inject
    DateParser(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public String apply(Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Date, "This function is only valid for Dates!");
        Date date = (Date)Date.class.cast(input);
        return this.dateService.iso8601SecondsDateFormat(date);
    }
}

