/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn;

import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.StarterCommand;
import es.bsc.conn.types.VirtualResource;
import java.util.Map;

public abstract class Connector {
    protected static final String PROP_APP_NAME = "app-name";
    protected static final String PROP_SERVER = "Server";
    protected static final String PROP_TIME_SLOT = "time-slot";
    protected static final String PROP_ADAPTOR_MAX_PORT = "adaptor-max-port";
    protected static final String PROP_ADAPTOR_MIN_PORT = "adaptor-min-port";
    protected static final String PROP_KEYPAIR_NAME = "vm-keypair-name";
    protected static final String PROP_KEYPAIR_LOC = "vm-keypair-location";
    protected static final String PROP_MAX_VM_CREATION_TIME = "max-vm-creation-time";
    protected static final String PROP_MAX_CONNECTION_ERRORS = "max-connection-errors";
    protected static final long MIN_TO_S = 60L;
    protected static final long S_TO_MS = 1000L;
    protected static final String DEFAULT_APP_NAME = "default-app";
    protected static final String DEFAULT_SERVER = null;
    protected static final long DEFAULT_TIME_SLOT = 300000L;
    protected static final int DEFAULT_MAX_PORT = -1;
    protected static final int DEFAULT_MIN_PORT = -1;
    protected static final String DEFAULT_KEYPAIR_NAME = "";
    protected static final String DEFAULT_KEYPAIR_LOC = "";
    protected static final long DEFAULT_VM_CREATION_TIME = 600000L;
    protected static final int DEFAULT_VM_CONNECTION_ERRORS = 3;
    protected final String appName;
    protected final String server;
    protected final long timeSlot;
    protected final String keypairName;
    protected final String keypairLoc;
    protected final long maxVMCreationTime;
    protected final int maxVMConnectionErrors;

    public Connector(Map<String, String> props) throws ConnException {
        String propAppName = props.get(PROP_APP_NAME);
        this.appName = propAppName != null && !propAppName.isEmpty() ? propAppName : DEFAULT_APP_NAME;
        String propServer = props.get(PROP_SERVER);
        this.server = propServer != null && !propServer.isEmpty() ? propServer : DEFAULT_SERVER;
        String propTimeSlot = props.get(PROP_TIME_SLOT);
        this.timeSlot = propTimeSlot != null && !propTimeSlot.isEmpty() ? Long.parseLong(propTimeSlot) * 60L * 1000L : 300000L;
        String propKeypairName = props.get(PROP_KEYPAIR_NAME);
        this.keypairName = propKeypairName != null && !propKeypairName.isEmpty() ? propKeypairName : "";
        String propKeypairLoc = props.get(PROP_KEYPAIR_LOC);
        this.keypairLoc = propKeypairLoc != null && !propKeypairLoc.isEmpty() ? propKeypairLoc : "";
        String propMaxVMCreationTime = props.get(PROP_MAX_VM_CREATION_TIME);
        this.maxVMCreationTime = propMaxVMCreationTime != null && !propMaxVMCreationTime.isEmpty() ? Long.parseLong(propMaxVMCreationTime) * 60L * 1000L : 600000L;
        String propMaxVMConnectionErrors = props.get(PROP_MAX_CONNECTION_ERRORS);
        this.maxVMConnectionErrors = propMaxVMConnectionErrors != null && !propMaxVMConnectionErrors.isEmpty() ? Integer.parseInt(propMaxVMConnectionErrors) : 3;
    }

    public abstract Object create(String var1, HardwareDescription var2, SoftwareDescription var3, Map<String, String> var4, StarterCommand var5) throws ConnException;

    public abstract Object[] createMultiple(int var1, String var2, HardwareDescription var3, SoftwareDescription var4, Map<String, String> var5, StarterCommand var6) throws ConnException;

    public abstract VirtualResource waitUntilCreation(Object var1) throws ConnException;

    public abstract void destroy(Object var1);

    public long getTimeSlot() {
        return this.timeSlot;
    }

    public abstract float getPriceSlot(VirtualResource var1);

    public abstract void close();
}

