/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.joyent.cloudapi.v6_5.domain.Dataset;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatasetInDatacenter;

public class DatasetInDatacenterToImage
implements Function<DatasetInDatacenter, Image> {
    private final Function<Dataset, OperatingSystem> imageToOs;
    private final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public DatasetInDatacenterToImage(Function<Dataset, OperatingSystem> imageToOs, Supplier<Map<String, Location>> locationIndex) {
        this.imageToOs = Preconditions.checkNotNull(imageToOs, "imageToOs");
        this.locationIndex = Preconditions.checkNotNull(locationIndex, "locationIndex");
    }

    @Override
    public Image apply(DatasetInDatacenter datasetInDatacenter) {
        Location location = this.locationIndex.get().get(datasetInDatacenter.getDatacenter());
        Preconditions.checkState(location != null, "location %s not in locationIndex: %s", datasetInDatacenter.getDatacenter(), this.locationIndex.get());
        Dataset dataset = datasetInDatacenter.get();
        return new ImageBuilder().id(datasetInDatacenter.slashEncode()).providerId(dataset.getUrn()).name(dataset.getName()).operatingSystem(this.imageToOs.apply(dataset)).description(dataset.getDescription()).version(dataset.getVersion()).location(location).status(Image.Status.AVAILABLE).build();
    }
}

