/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;

@Singleton
public class NovaSecurityGroupInRegionToSecurityGroup
implements Function<SecurityGroupInRegion, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroup> baseConverter;
    protected final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public NovaSecurityGroupInRegionToSecurityGroup(Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroup> baseConverter, Supplier<Map<String, Location>> locationIndex) {
        this.baseConverter = Preconditions.checkNotNull(baseConverter, "baseConverter");
        this.locationIndex = Preconditions.checkNotNull(locationIndex, "locationIndex");
    }

    @Override
    public SecurityGroup apply(SecurityGroupInRegion group) {
        SecurityGroupBuilder builder = SecurityGroupBuilder.fromSecurityGroup(this.baseConverter.apply(group.getSecurityGroup()));
        Location region = this.locationIndex.get().get(group.getRegion());
        Preconditions.checkState(region != null, "location %s not in locationIndex: %s", group.getRegion(), this.locationIndex.get());
        builder.location(region);
        builder.id(group.getRegion() + "/" + group.getSecurityGroup().getId());
        return builder.build();
    }
}

