/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.SoftwareDescription;

public class SoftwareLicense {
    private final int id;
    private final SoftwareDescription softwareDescription;
    private final int softwareDescriptionId;

    @ConstructorProperties(value={"id", "softwareDescription", "softwareDescriptionId"})
    protected SoftwareLicense(int id, @Nullable SoftwareDescription softwareDescription, int softwareDescriptionId) {
        this.id = id;
        this.softwareDescription = softwareDescription;
        this.softwareDescriptionId = softwareDescriptionId;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public SoftwareDescription getSoftwareDescription() {
        return this.softwareDescription;
    }

    public int getSoftwareDescriptionId() {
        return this.softwareDescriptionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoftwareLicense that = (SoftwareLicense)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.softwareDescription, that.softwareDescription) && Objects.equal(this.softwareDescriptionId, that.softwareDescriptionId);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.softwareDescription, this.softwareDescriptionId);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("id", this.id).add("softwareDescription", this.softwareDescription).add("softwareDescriptionId", this.softwareDescriptionId).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SoftwareLicense.builder().fromSoftwareLicense(this);
    }

    public static class Builder {
        protected int id;
        protected SoftwareDescription softwareDescription;
        protected int softwareDescriptionId;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder softwareDescription(SoftwareDescription softwareDescription) {
            this.softwareDescription = softwareDescription;
            return this;
        }

        public Builder softwareDescriptionId(int softwareDescriptionId) {
            this.softwareDescriptionId = softwareDescriptionId;
            return this;
        }

        public SoftwareLicense build() {
            return new SoftwareLicense(this.id, this.softwareDescription, this.softwareDescriptionId);
        }

        public Builder fromSoftwareLicense(SoftwareLicense in) {
            return this.id(in.getId()).softwareDescription(in.getSoftwareDescription()).softwareDescriptionId(in.getSoftwareDescriptionId());
        }
    }
}

