/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts.xml;

import com.google.inject.Inject;
import org.jclouds.aws.xml.SessionCredentialsHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.sts.domain.User;
import org.jclouds.sts.domain.UserAndSessionCredentials;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UserAndSessionCredentialsHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<UserAndSessionCredentials> {
    private final SessionCredentialsHandler credsHandler;
    private StringBuilder currentText = new StringBuilder();
    private UserAndSessionCredentials.Builder builder = UserAndSessionCredentials.builder();
    private boolean inCreds;
    private String arn;
    private String id;

    @Inject
    public UserAndSessionCredentialsHandler(SessionCredentialsHandler credsHandler) {
        this.credsHandler = credsHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserAndSessionCredentials getResult() {
        try {
            UserAndSessionCredentials userAndSessionCredentials = this.builder.build();
            return userAndSessionCredentials;
        }
        finally {
            this.builder = UserAndSessionCredentials.builder();
        }
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "Credentials")) {
            this.inCreds = true;
        }
        if (this.inCreds) {
            this.credsHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.inCreds) {
            if (qName.equals("Credentials")) {
                this.inCreds = false;
                this.builder.credentials(this.credsHandler.getResult());
            } else {
                this.credsHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("Arn")) {
            this.arn = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.endsWith("Id")) {
            this.id = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.endsWith("User")) {
            this.builder.user(User.fromIdAndArn(this.id, this.arn));
            this.arn = null;
            this.id = null;
        } else if (qName.equals("PackedPolicySize")) {
            this.builder.packedPolicySize(Integer.parseInt(SaxUtils.currentOrNull(this.currentText)));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inCreds) {
            this.credsHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

