/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.concurrent.SingleThreaded;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.config.BindApiContextWithWildcardExtendsExplicitAndRawType;
import org.jclouds.config.BindNameToContext;
import org.jclouds.config.BindPropertiesToExpandedValues;
import org.jclouds.domain.Credentials;
import org.jclouds.events.config.ConfiguresEventBus;
import org.jclouds.events.config.EventBusModule;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.JavaUrlHttpCommandExecutorServiceModule;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.lifecycle.config.LifeCycleModule;
import org.jclouds.logging.config.LoggingModule;
import org.jclouds.logging.jdk.config.JDKLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;
import org.jclouds.providers.config.BindProviderMetadataContextAndCredentials;
import org.jclouds.providers.internal.UpdateProviderMetadataFromProperties;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresCredentialStore;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.HttpApiMetadata;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.CredentialStoreModule;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.config.RestModule;
import org.jclouds.rest.internal.InvokeHttpMethod;
import org.jclouds.util.Throwables2;

public class ContextBuilder {
    private static final Stage GUICE_STAGE = Stage.PRODUCTION;
    protected Optional<String> name = Optional.absent();
    protected Optional<ProviderMetadata> providerMetadata = Optional.absent();
    protected final String providerId;
    protected Optional<String> endpoint = Optional.absent();
    protected Optional<String> identity = Optional.absent();
    protected Optional<Supplier<Credentials>> credentialsSupplierOption = Optional.absent();
    @Nullable
    protected String credential;
    protected ApiMetadata apiMetadata;
    protected String apiVersion;
    protected String buildVersion;
    protected Optional<Properties> overrides = Optional.absent();
    protected List<Module> modules = Lists.newArrayListWithCapacity(3);
    private static Predicate<Module> configuresApi = new Predicate<Module>(){

        @Override
        public boolean apply(Module input) {
            return input.getClass().isAnnotationPresent(ConfiguresHttpApi.class);
        }
    };

    public static ContextBuilder newBuilder(String providerOrApi) throws NoSuchElementException {
        try {
            return ContextBuilder.newBuilder(Providers.withId(providerOrApi));
        }
        catch (NoSuchElementException e) {
            try {
                return ContextBuilder.newBuilder(Apis.withId(providerOrApi));
            }
            catch (NoSuchElementException e2) {
                ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
                builder.putAll("providers", Iterables.transform(Providers.all(), Providers.idFunction()));
                builder.putAll("apis", Iterables.transform(Apis.all(), Apis.idFunction()));
                throw new NoSuchElementException(String.format("key [%s] not in the list of providers or apis: %s", providerOrApi, builder.build()));
            }
        }
    }

    public static ContextBuilder newBuilder(ApiMetadata apiMetadata) {
        try {
            return new ContextBuilder(apiMetadata);
        }
        catch (Exception e) {
            return (ContextBuilder)Throwables2.propagateAuthorizationOrOriginalException(e);
        }
    }

    public static ContextBuilder newBuilder(ProviderMetadata providerMetadata) {
        try {
            return new ContextBuilder(providerMetadata);
        }
        catch (Exception e) {
            return (ContextBuilder)Throwables2.propagateAuthorizationOrOriginalException(e);
        }
    }

    public String toString() {
        return Objects.toStringHelper("").add("providerMetadata", this.providerMetadata).add("apiMetadata", this.apiMetadata).toString();
    }

    protected ContextBuilder(ProviderMetadata providerMetadata) {
        this(providerMetadata, Preconditions.checkNotNull(providerMetadata, "providerMetadata").getApiMetadata());
    }

    protected ContextBuilder(@Nullable ProviderMetadata providerMetadata, ApiMetadata apiMetadata) {
        this.apiMetadata = Preconditions.checkNotNull(apiMetadata, "apiMetadata");
        if (providerMetadata != null) {
            this.providerMetadata = Optional.of(providerMetadata);
            this.endpoint = Optional.of(providerMetadata.getEndpoint());
            this.providerId = providerMetadata.getId();
        } else {
            this.endpoint = apiMetadata.getDefaultEndpoint();
            this.providerId = apiMetadata.getId();
        }
        this.identity = apiMetadata.getDefaultIdentity();
        this.credential = apiMetadata.getDefaultCredential().orNull();
        this.apiVersion = apiMetadata.getVersion();
        this.buildVersion = apiMetadata.getBuildVersion().or("");
    }

    public ContextBuilder(ApiMetadata apiMetadata) {
        this(null, apiMetadata);
    }

    public ContextBuilder name(String name) {
        this.name = Optional.of(Preconditions.checkNotNull(name, "name"));
        return this;
    }

    public ContextBuilder credentialsSupplier(Supplier<Credentials> credentialsSupplier) {
        this.credentialsSupplierOption = Optional.of(Preconditions.checkNotNull(credentialsSupplier, "credentialsSupplier"));
        return this;
    }

    public ContextBuilder credentials(String identity, @Nullable String credential) {
        this.identity = Optional.of(Preconditions.checkNotNull(identity, "identity"));
        this.credential = credential;
        return this;
    }

    public ContextBuilder endpoint(String endpoint) {
        this.endpoint = Optional.of(Preconditions.checkNotNull(endpoint, "endpoint"));
        return this;
    }

    public ContextBuilder apiVersion(String apiVersion) {
        this.apiVersion = Preconditions.checkNotNull(apiVersion, "apiVersion");
        return this;
    }

    public ContextBuilder buildVersion(String buildVersion) {
        this.buildVersion = Preconditions.checkNotNull(buildVersion, "buildVersion");
        return this;
    }

    public ContextBuilder modules(Iterable<? extends Module> modules) {
        Iterables.addAll(this.modules, Preconditions.checkNotNull(modules, "modules"));
        return this;
    }

    public ContextBuilder overrides(Properties overrides) {
        this.overrides = Optional.of(Preconditions.checkNotNull(overrides, "overrides"));
        return this;
    }

    public static String searchPropertiesForProviderScopedProperty(Properties mutable, String prov, String key) throws NoSuchElementException {
        try {
            String string = Iterables.find(Lists.newArrayList(mutable.getProperty(prov + "." + key), mutable.getProperty("jclouds." + key)), Predicates.notNull());
            return string;
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("property %s.%s not present in properties: %s", prov, key, mutable.keySet()));
        }
        finally {
            mutable.remove(prov + "." + key);
            mutable.remove("jclouds." + key);
        }
    }

    public Injector buildInjector() {
        Properties unexpanded = this.currentStateToUnexpandedProperties();
        ImmutableSet<String> keysToResolve = ImmutableSet.of("jclouds.identity", "jclouds.credential", "jclouds.endpoint", "jclouds.api", "jclouds.api-version", "jclouds.build-version", new String[0]);
        ImmutableSet<String> optionalKeys = this.credentialsSupplierOption.isPresent() ? ImmutableSet.of("jclouds.identity", "jclouds.credential") : (!this.apiMetadata.getCredentialName().isPresent() ? ImmutableSet.of("jclouds.credential") : ImmutableSet.of());
        Properties resolved = ContextBuilder.resolveProperties(unexpanded, this.providerId, keysToResolve, optionalKeys);
        Properties expanded = this.expandProperties(resolved);
        Supplier<Credentials> credentialsSupplier = this.buildCredentialsSupplier(expanded);
        ProviderMetadata providerMetadata = new UpdateProviderMetadataFromProperties(this.apiMetadata, this.providerMetadata).apply(expanded);
        return ContextBuilder.buildInjector(this.name.or(String.valueOf(Objects.hashCode(providerMetadata.getId(), providerMetadata.getEndpoint(), providerMetadata.getApiMetadata().getVersion(), credentialsSupplier))), providerMetadata, credentialsSupplier, this.modules);
    }

    protected Supplier<Credentials> buildCredentialsSupplier(Properties expanded) {
        Credentials creds = new Credentials(ContextBuilder.getAndRemove(expanded, "jclouds.identity"), ContextBuilder.getAndRemove(expanded, "jclouds.credential"));
        Supplier<Credentials> credentialsSupplier = this.credentialsSupplierOption.isPresent() ? this.credentialsSupplierOption.get() : Suppliers.ofInstance(creds);
        return credentialsSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAndRemove(Properties expanded, String key) {
        try {
            String string = expanded.getProperty(key);
            return string;
        }
        finally {
            expanded.remove(key);
        }
    }

    private Properties currentStateToUnexpandedProperties() {
        Properties defaults = new Properties();
        defaults.putAll((Map<?, ?>)this.apiMetadata.getDefaultProperties());
        defaults.setProperty("jclouds.provider", this.providerId);
        if (this.providerMetadata.isPresent()) {
            defaults.putAll((Map<?, ?>)this.providerMetadata.get().getDefaultProperties());
            defaults.setProperty("jclouds.iso3166-codes", Joiner.on(',').join(this.providerMetadata.get().getIso3166Codes()));
        }
        if (this.endpoint.isPresent()) {
            defaults.setProperty("jclouds.endpoint", this.endpoint.get());
        }
        defaults.setProperty("jclouds.api", this.apiMetadata.getName());
        defaults.setProperty("jclouds.api-version", this.apiVersion);
        defaults.setProperty("jclouds.build-version", this.buildVersion);
        if (this.identity.isPresent()) {
            defaults.setProperty("jclouds.identity", this.identity.get());
        }
        if (this.credential != null) {
            defaults.setProperty("jclouds.credential", this.credential);
        }
        if (this.overrides.isPresent()) {
            defaults.putAll((Map<?, ?>)Preconditions.checkNotNull(this.overrides.get(), "overrides"));
        }
        defaults.putAll(ContextBuilder.propertiesPrefixedWithJcloudsApiOrProviderId(this.getSystemProperties(), this.apiMetadata.getId(), this.providerId));
        return defaults;
    }

    @VisibleForTesting
    protected Properties getSystemProperties() {
        return System.getProperties();
    }

    private Properties expandProperties(Properties resolved) {
        return Guice.createInjector(GUICE_STAGE, new BindPropertiesToExpandedValues(resolved)).getInstance(Properties.class);
    }

    public static Injector buildInjector(String name, ProviderMetadata providerMetadata, Supplier<Credentials> creds, List<Module> inputModules) {
        ArrayList<Module> modules = Lists.newArrayList();
        modules.addAll(inputModules);
        boolean apiModuleSpecifiedByUser = ContextBuilder.apiModulePresent(inputModules);
        Iterable<Module> defaultModules = ContextBuilder.ifSpecifiedByUserDontIncludeDefaultApiModule(providerMetadata.getApiMetadata(), apiModuleSpecifiedByUser);
        Iterables.addAll(modules, defaultModules);
        ContextBuilder.addClientModuleIfNotPresent(providerMetadata.getApiMetadata(), modules);
        ContextBuilder.addRestContextBinding(providerMetadata.getApiMetadata(), modules);
        ContextBuilder.addLoggingModuleIfNotPresent(modules);
        ContextBuilder.addHttpModuleIfNeededAndNotPresent(modules);
        ContextBuilder.addExecutorServiceIfNotPresent(modules);
        ContextBuilder.addEventBusIfNotPresent(modules);
        ContextBuilder.addCredentialStoreIfNotPresent(modules);
        modules.add(new LifeCycleModule());
        modules.add(new BindProviderMetadataContextAndCredentials(providerMetadata, creds));
        modules.add(new BindNameToContext(name));
        Injector returnVal = Guice.createInjector(GUICE_STAGE, modules);
        returnVal.getInstance(ExecutionList.class).execute();
        return returnVal;
    }

    static Properties resolveProperties(Properties mutable, String providerId, Set<String> keys, Set<String> optionalKeys) throws NoSuchElementException {
        for (String key : keys) {
            String scopedProperty = Iterables.get(Splitter.on('.').split(key), 1);
            try {
                mutable.setProperty(key, ContextBuilder.searchPropertiesForProviderScopedProperty(mutable, providerId, scopedProperty));
            }
            catch (NoSuchElementException e) {
                if (optionalKeys.contains(key)) continue;
                throw e;
            }
        }
        return mutable;
    }

    static void addRestContextBinding(ApiMetadata apiMetadata, List<Module> modules) {
        if (apiMetadata instanceof HttpApiMetadata) {
            try {
                modules.add(new BindApiContextWithWildcardExtendsExplicitAndRawType((HttpApiMetadata)HttpApiMetadata.class.cast(apiMetadata)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    static Iterable<Module> ifSpecifiedByUserDontIncludeDefaultApiModule(ApiMetadata apiMetadata, boolean restModuleSpecifiedByUser) {
        Iterable<Module> defaultModules = Iterables.transform(apiMetadata.getDefaultModules(), new Function<Class<? extends Module>, Module>(){

            @Override
            public Module apply(Class<? extends Module> arg0) {
                try {
                    return arg0.newInstance();
                }
                catch (InstantiationException e) {
                    throw Throwables.propagate(e);
                }
                catch (IllegalAccessException e) {
                    throw Throwables.propagate(e);
                }
            }
        });
        if (restModuleSpecifiedByUser) {
            defaultModules = Iterables.filter(defaultModules, Predicates.not(configuresApi));
        }
        return defaultModules;
    }

    static Map<String, Object> propertiesPrefixedWithJcloudsApiOrProviderId(Properties properties, String apiId, String providerId) {
        return Maps.filterKeys((Map)Map.class.cast(properties), Predicates.containsPattern("^(jclouds|" + providerId + "|" + apiId + ").*"));
    }

    @VisibleForTesting
    static void addLoggingModuleIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, Predicates.instanceOf(LoggingModule.class))) {
            modules.add(new JDKLoggingModule());
        }
    }

    @VisibleForTesting
    static void addHttpModuleIfNeededAndNotPresent(List<Module> modules) {
        if (ContextBuilder.nothingConfiguresAnHttpService(modules)) {
            modules.add(new JavaUrlHttpCommandExecutorServiceModule());
        }
    }

    static boolean nothingConfiguresAnHttpService(List<Module> modules) {
        return !Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresHttpCommandExecutorService.class);
            }
        });
    }

    @VisibleForTesting
    static void addClientModuleIfNotPresent(ApiMetadata apiMetadata, List<Module> modules) {
        if (!ContextBuilder.apiModulePresent(modules)) {
            ContextBuilder.addClientModule(apiMetadata, modules);
        }
    }

    private static boolean apiModulePresent(List<Module> modules) {
        return Iterables.any(modules, configuresApi);
    }

    static void addClientModule(ApiMetadata apiMetadata, List<Module> modules) {
        if (apiMetadata instanceof HttpApiMetadata) {
            HttpApiMetadata api = (HttpApiMetadata)HttpApiMetadata.class.cast(apiMetadata);
            modules.add(new HttpApiModule(api.getApi()));
        } else {
            modules.add(new RestModule());
            modules.add(new AbstractModule(){

                @Override
                public void configure() {
                    this.bind(new TypeLiteral<Function<Invocation, Object>>(){}).to(InvokeHttpMethod.class);
                    BinderUtils.bindHttpApi(this.binder(), HttpClient.class);
                }
            });
        }
    }

    @VisibleForTesting
    static void addEventBusIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresEventBus.class);
            }
        })) {
            modules.add(new EventBusModule());
        }
    }

    @VisibleForTesting
    static void addExecutorServiceIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresExecutorService.class);
            }
        })) {
            if (Iterables.any(modules, new Predicate<Module>(){

                @Override
                public boolean apply(Module input) {
                    return input.getClass().isAnnotationPresent(SingleThreaded.class);
                }
            })) {
                modules.add(new ExecutorServiceModule(MoreExecutors.sameThreadExecutor()));
            } else {
                modules.add(new ExecutorServiceModule());
            }
        }
    }

    @VisibleForTesting
    static void addCredentialStoreIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresCredentialStore.class);
            }
        })) {
            modules.add(new CredentialStoreModule());
        }
    }

    public <C extends Context> C build() {
        return (C)this.build(this.apiMetadata.getContext());
    }

    public <V extends View> V build(Class<V> viewType) {
        return this.buildView(Preconditions.checkNotNull(viewType, "viewType"));
    }

    public <V extends View> V buildView(Class<V> viewType) {
        return this.buildView(Reflection2.typeToken(viewType));
    }

    public <V extends View> V buildView(TypeToken<V> viewType) {
        TypeToken<?> returnType;
        try {
            returnType = Apis.findView(this.apiMetadata, Preconditions.checkNotNull(viewType, "viewType"));
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(String.format("api %s not wrappable as %s; context: %s, views: %s", this.apiMetadata, viewType, this.apiMetadata.getContext(), this.apiMetadata.getViews()));
        }
        return (V)((View)this.buildInjector().getInstance(Key.get(TypeLiteral.get(returnType.getType()))));
    }

    public <C extends Context> C build(TypeToken<C> contextType) {
        TypeToken<? extends Context> returnType = null;
        if (!contextType.isAssignableFrom(this.apiMetadata.getContext())) {
            throw new IllegalArgumentException(String.format("api %s not assignable from %s; context: %s", this.apiMetadata, contextType, this.apiMetadata.getContext()));
        }
        returnType = this.apiMetadata.getContext();
        return (C)((Context)this.buildInjector().getInstance(Key.get(TypeLiteral.get(returnType.getType()))));
    }

    public <A extends Closeable> A buildApi(Class<A> api) {
        return this.buildApi(Reflection2.typeToken(api));
    }

    public <A extends Closeable> A buildApi(TypeToken<A> apiType) {
        return (A)((Closeable)this.buildInjector().getInstance(Key.get(TypeLiteral.get(apiType.getType()))));
    }

    public ApiMetadata getApiMetadata() {
        return this.apiMetadata;
    }
}

