/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import java.util.Date;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.ec2.domain.BundleTask;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;

public class BundleTaskHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<BundleTask> {
    protected final DateCodec dateCodec;
    protected final Supplier<String> defaultRegion;
    private StringBuilder currentText = new StringBuilder();
    private String bundleId;
    private String code;
    private String message;
    private String instanceId;
    private int progress = 0;
    private Date startTime;
    private String state;
    private String bucket;
    private String prefix;
    private Date updateTime;

    @Inject
    protected BundleTaskHandler(DateCodecFactory dateCodecFactory, @Region Supplier<String> defaultRegion) {
        this.dateCodec = dateCodecFactory.iso8601();
        this.defaultRegion = defaultRegion;
    }

    @Override
    public BundleTask getResult() {
        String region = AWSUtils.findRegionInArgsOrNull(this.getRequest());
        if (region == null) {
            region = this.defaultRegion.get();
        }
        BundleTask.Error error = null;
        if (this.code != null) {
            error = new BundleTask.Error(this.code, this.message);
        }
        BundleTask returnVal = new BundleTask(region, this.bundleId, error, this.instanceId, this.progress, this.startTime, this.state, this.bucket, this.prefix, this.updateTime);
        this.bundleId = null;
        this.code = null;
        this.message = null;
        this.instanceId = null;
        this.progress = 0;
        this.startTime = null;
        this.state = null;
        this.bucket = null;
        this.prefix = null;
        this.updateTime = null;
        return returnVal;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("bundleId")) {
            this.bundleId = this.currentText.toString().trim();
        } else if (qName.equals("code")) {
            this.code = this.currentText.toString().trim();
        } else if (qName.equals("message")) {
            this.message = this.currentText.toString().trim();
        } else if (qName.equals("instanceId")) {
            this.instanceId = this.currentText.toString().trim();
        } else if (qName.equals("progress")) {
            String temp = this.currentText.toString().trim();
            temp = temp.substring(0, temp.length() - 1);
            this.progress = Integer.parseInt(temp);
        } else if (qName.equals("startTime")) {
            this.startTime = this.dateCodec.toDate(this.currentText.toString().trim());
        } else if (qName.equals("state")) {
            this.state = this.currentText.toString().trim();
        } else if (qName.equals("bucket")) {
            this.bucket = this.currentText.toString().trim();
        } else if (qName.equals("prefix")) {
            this.prefix = this.currentText.toString().trim();
        } else if (qName.equals("updateTime")) {
            this.updateTime = this.dateCodec.toDate(this.currentText.toString().trim());
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

