/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import javax.inject.Inject;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.domain.NetworkAndAddressRange;
import org.jclouds.googlecomputeengine.domain.Network;

public final class FindNetworkOrCreate
extends CacheLoader<NetworkAndAddressRange, Network> {
    private final GoogleComputeEngineApi api;
    private final Function<NetworkAndAddressRange, Network> networkCreator;

    @Inject
    FindNetworkOrCreate(GoogleComputeEngineApi api, Function<NetworkAndAddressRange, Network> networkCreator) {
        this.api = api;
        this.networkCreator = networkCreator;
    }

    @Override
    public Network load(NetworkAndAddressRange in) {
        Network network = this.api.networks().get(in.name());
        if (network != null) {
            return network;
        }
        return this.networkCreator.apply(in);
    }
}

