/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.domain.Instance;

public final class InstanceToNodeMetadata
implements Function<Instance, NodeMetadata> {
    private final Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus;
    private final GroupNamingConvention nodeNamingConvention;
    private final Map<URI, URI> diskToSourceImage;
    private final Supplier<Map<URI, Hardware>> hardwares;
    private final Supplier<Map<URI, Location>> locationsByUri;
    private final FirewallTagNamingConvention.Factory firewallTagNamingConvention;

    @Inject
    InstanceToNodeMetadata(Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus, GroupNamingConvention.Factory namingConvention, Map<URI, URI> diskToSourceImage, @Memoized Supplier<Map<URI, Hardware>> hardwares, @Memoized Supplier<Map<URI, Location>> locationsByUri, FirewallTagNamingConvention.Factory firewallTagNamingConvention) {
        this.toPortableNodeStatus = toPortableNodeStatus;
        this.nodeNamingConvention = namingConvention.createWithoutPrefix();
        this.diskToSourceImage = diskToSourceImage;
        this.hardwares = hardwares;
        this.locationsByUri = locationsByUri;
        this.firewallTagNamingConvention = Preconditions.checkNotNull(firewallTagNamingConvention, "firewallTagNamingConvention");
    }

    @Override
    public NodeMetadata apply(Instance input) {
        String group = ComputeServiceUtils.groupFromMapOrName(input.metadata().asMap(), input.name(), this.nodeNamingConvention);
        try {
            Predicate<String> isFirewallTag = this.firewallTagNamingConvention.get(group).isFirewallTag();
            if (group != null) {
                Iterator<String> tag = input.tags().items().iterator();
                while (tag.hasNext()) {
                    if (!isFirewallTag.apply(tag.next())) continue;
                    tag.remove();
                }
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        Location zone = this.locationsByUri.get().get(input.zone());
        if (zone == null) {
            throw new IllegalStateException(String.format("zone %s not present in %s", input.zone(), this.locationsByUri.get().keySet()));
        }
        URI bootImage = this.diskToSourceImage.get(input.disks().get(0).source());
        ((NodeMetadataBuilder)((NodeMetadataBuilder)builder.id(input.selfLink().toString()).providerId(input.id()).name(input.name()).providerId(input.id()).hostname(input.name()).location(zone).imageId(bootImage != null ? bootImage.toString() : null).hardware(this.hardwares.get().get(input.machineType())).status(input.status() != null ? this.toPortableNodeStatus.get((Object)input.status()) : NodeMetadata.Status.UNRECOGNIZED).tags(input.tags().items())).uri(input.selfLink()).userMetadata((Map)input.metadata().asMap())).group(group).privateAddresses(this.collectPrivateAddresses(input)).publicAddresses(this.collectPublicAddresses(input));
        return builder.build();
    }

    private List<String> collectPrivateAddresses(Instance input) {
        ImmutableList.Builder privateAddressesBuilder = ImmutableList.builder();
        for (Instance.NetworkInterface networkInterface : input.networkInterfaces()) {
            if (networkInterface.networkIP() == null) continue;
            privateAddressesBuilder.add(networkInterface.networkIP());
        }
        return privateAddressesBuilder.build();
    }

    private List<String> collectPublicAddresses(Instance input) {
        ImmutableList.Builder publicAddressesBuilder = ImmutableList.builder();
        for (Instance.NetworkInterface networkInterface : input.networkInterfaces()) {
            for (Instance.NetworkInterface.AccessConfig accessConfig : networkInterface.accessConfigs()) {
                if (accessConfig.natIP() == null) continue;
                publicAddressesBuilder.add(accessConfig.natIP());
            }
        }
        return publicAddressesBuilder.build();
    }
}

