/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.NetworkVlan;

public class VirtualGuestNetworkComponent {
    private final int id;
    private final String uuid;
    private final int guestId;
    private final int networkId;
    private final String macAddress;
    private final int maxSpeed;
    private final String name;
    private final int port;
    private final int speed;
    private final String status;
    private final NetworkVlan networkVlan;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VirtualGuestNetworkComponent.builder().fromVirtualGuestNetworkComponent(this);
    }

    @ConstructorProperties(value={"id", "uuid", "guestId", "networkId", "macAddress", "maxSpeed", "name", "port", "speed", "status", "networkVlan"})
    protected VirtualGuestNetworkComponent(int id, String uuid, int guestId, int networkId, @Nullable String macAddress, int maxSpeed, @Nullable String name, int port, int speed, @Nullable String status, @Nullable NetworkVlan networkVlan) {
        this.id = id;
        this.uuid = uuid;
        this.guestId = guestId;
        this.networkId = networkId;
        this.macAddress = macAddress;
        this.maxSpeed = maxSpeed;
        this.name = name;
        this.port = port;
        this.speed = speed;
        this.status = status;
        this.networkVlan = networkVlan;
    }

    public int getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public int getGuestId() {
        return this.guestId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public int getSpeed() {
        return this.speed;
    }

    public String getStatus() {
        return this.status;
    }

    public NetworkVlan getNetworkVlan() {
        return this.networkVlan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualGuestNetworkComponent that = (VirtualGuestNetworkComponent)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.uuid, that.uuid) && Objects.equal(this.guestId, that.guestId) && Objects.equal(this.networkId, that.networkId) && Objects.equal(this.macAddress, that.macAddress) && Objects.equal(this.maxSpeed, that.maxSpeed) && Objects.equal(this.name, that.name) && Objects.equal(this.port, that.port) && Objects.equal(this.speed, that.speed) && Objects.equal(this.status, that.status) && Objects.equal(this.networkVlan, that.networkVlan);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.uuid, this.guestId, this.networkId, this.macAddress, this.maxSpeed, this.name, this.port, this.speed, this.status, this.networkVlan);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("id", this.id).add("uuid", this.uuid).add("guestId", this.guestId).add("networkId", this.networkId).add("macAddress", this.macAddress).add("maxSpeed", this.maxSpeed).add("name", this.name).add("port", this.port).add("speed", this.speed).add("status", this.status).add("networkVlan", this.networkVlan).toString();
    }

    public static class Builder {
        protected int id;
        protected String uuid;
        protected int guestId;
        protected int networkId;
        protected String macAddress;
        protected int maxSpeed;
        protected String name;
        protected int port;
        protected int speed;
        protected String status;
        protected NetworkVlan networkVlan;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder guestId(int guestId) {
            this.guestId = guestId;
            return this;
        }

        public Builder networkId(int networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public Builder maxSpeed(int maxSpeed) {
            this.maxSpeed = maxSpeed;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder speed(int speed) {
            this.speed = speed;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder networkVlan(NetworkVlan networkVlan) {
            this.networkVlan = networkVlan;
            return this;
        }

        public VirtualGuestNetworkComponent build() {
            return new VirtualGuestNetworkComponent(this.id, this.uuid, this.guestId, this.networkId, this.macAddress, this.maxSpeed, this.name, this.port, this.speed, this.status, this.networkVlan);
        }

        public Builder fromVirtualGuestNetworkComponent(VirtualGuestNetworkComponent in) {
            return this.id(in.getId()).uuid(in.getUuid()).guestId(in.getGuestId()).networkId(in.getNetworkId()).macAddress(in.getMacAddress()).maxSpeed(in.getMaxSpeed()).port(in.getPort()).speed(in.getSpeed()).status(in.getStatus()).networkVlan(in.getNetworkVlan());
        }
    }
}

