/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.xml.CreateVolumeResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DescribeVolumesResponseHandler
extends ParseSax.HandlerWithResult<Set<Volume>> {
    private Set<Volume> volumes = Sets.newLinkedHashSet();
    private final CreateVolumeResponseHandler volumeHandler;
    private boolean inAttachmentSet;

    @Inject
    public DescribeVolumesResponseHandler(CreateVolumeResponseHandler volumeHandler) {
        this.volumeHandler = volumeHandler;
    }

    @Override
    public Set<Volume> getResult() {
        return this.volumes;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("attachmentSet")) {
            this.inAttachmentSet = true;
        }
        this.volumeHandler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.volumeHandler.endElement(uri, localName, qName);
        if (qName.equals("attachmentSet")) {
            this.inAttachmentSet = false;
        } else if (qName.equals("item") && !this.inAttachmentSet) {
            this.volumes.add(this.volumeHandler.getResult());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.volumeHandler.characters(ch, start, length);
    }

    @Override
    public DescribeVolumesResponseHandler setContext(HttpRequest request) {
        this.volumeHandler.setContext(request);
        super.setContext(request);
        return this;
    }
}

