/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;

@Singleton
public class CreateSecurityGroupIfNeeded
implements Function<RegionSecurityGroupNameAndPorts, SecurityGroupInRegion> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;

    @Inject
    public CreateSecurityGroupIfNeeded(NovaApi novaApi) {
        this.novaApi = Preconditions.checkNotNull(novaApi, "novaApi");
    }

    @Override
    public SecurityGroupInRegion apply(RegionSecurityGroupNameAndPorts regionSecurityGroupNameAndPorts) {
        Preconditions.checkNotNull(regionSecurityGroupNameAndPorts, "regionSecurityGroupNameAndPorts");
        String regionId = regionSecurityGroupNameAndPorts.getRegion();
        Optional<SecurityGroupApi> api = this.novaApi.getSecurityGroupApi(regionId);
        Preconditions.checkArgument(api.isPresent(), "Security groups are required, but the extension is not available in region %s!", regionId);
        this.logger.debug(">> creating securityGroup %s", regionSecurityGroupNameAndPorts);
        try {
            SecurityGroup securityGroup = api.get().createWithDescription(regionSecurityGroupNameAndPorts.getName(), regionSecurityGroupNameAndPorts.getName());
            this.logger.debug("<< created securityGroup(%s)", securityGroup);
            for (int port : regionSecurityGroupNameAndPorts.getPorts()) {
                this.authorizeGroupToItselfAndAllIPsToTCPPort(api.get(), securityGroup, port);
            }
            return new SecurityGroupInRegion(api.get().get(securityGroup.getId()), regionId);
        }
        catch (IllegalStateException e) {
            this.logger.trace("<< trying to find securityGroup(%s): %s", regionSecurityGroupNameAndPorts, e.getMessage());
            SecurityGroup group = Iterables.find(api.get().list(), SecurityGroupPredicates.nameEquals(regionSecurityGroupNameAndPorts.getName()));
            this.logger.debug("<< reused securityGroup(%s)", group.getId());
            return new SecurityGroupInRegion(group, regionId);
        }
    }

    private void authorizeGroupToItselfAndAllIPsToTCPPort(SecurityGroupApi securityGroupApi, SecurityGroup securityGroup, int port) {
        this.logger.debug(">> authorizing securityGroup(%s) permission to 0.0.0.0/0 on port %d", securityGroup, port);
        securityGroupApi.createRuleAllowingCidrBlock(securityGroup.getId(), ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(IpProtocol.TCP)).fromPort(port)).toPort(port)).build(), "0.0.0.0/0");
        this.logger.debug("<< authorized securityGroup(%s) permission to 0.0.0.0/0 on port %d", securityGroup, port);
    }
}

