/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class BaseAWSReservationHandler<T>
extends ParseSax.HandlerForGeneratedRequestWithResult<T> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final DateCodec dateCodec;
    protected final Supplier<String> defaultRegion;
    protected AWSRunningInstance.Builder builder = this.newBuilder();
    protected StringBuilder currentText = new StringBuilder();
    protected int itemDepth;
    boolean inInstancesSet;
    private String volumeId;
    private Attachment.Status attachmentStatus;
    private Date attachTime;
    private boolean deleteOnTermination;
    private String deviceName;
    private String groupId;
    private Map<String, String> reservationGroupIdToNames = Maps.newLinkedHashMap();
    private String ownerId;
    private String requesterId;
    private String reservationId;
    private Set<RunningInstance> instances = Sets.newLinkedHashSet();
    private boolean inPlacement;
    private boolean inIamInstanceProfile;

    @Inject
    public BaseAWSReservationHandler(DateCodecFactory dateCodecFactory, @Region Supplier<String> defaultRegion) {
        this.dateCodec = dateCodecFactory.iso8601();
        this.defaultRegion = defaultRegion;
    }

    protected AWSRunningInstance.Builder newBuilder() {
        return AWSRunningInstance.builder();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "item")) {
            ++this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix(qName, "instancesSet")) {
            this.inInstancesSet = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "placement")) {
            this.inPlacement = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "iamInstanceProfile")) {
            this.inIamInstanceProfile = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "item")) {
            this.inItem();
            --this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix(qName, "state")) {
            this.builder.monitoringState(MonitoringState.fromValue(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "groupId")) {
            this.groupId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "groupName") && this.inPlacement) {
            this.builder.placementGroup(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "arn") && this.inIamInstanceProfile) {
            this.builder.iamInstanceProfileArn(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "id") && this.inIamInstanceProfile) {
            this.builder.iamInstanceProfileId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "groupName")) {
            switch (this.itemDepth) {
                case 2: {
                    this.reservationGroupIdToNames.put(this.groupId, SaxUtils.currentOrNull(this.currentText));
                    break;
                }
                case 3: {
                    this.builder.securityGroupIdToName(this.groupId, SaxUtils.currentOrNull(this.currentText));
                }
            }
            this.groupId = null;
        } else if (SaxUtils.equalsOrSuffix(qName, "subnetId")) {
            this.builder.subnetId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "spotInstanceRequestId")) {
            this.builder.spotInstanceRequestId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "vpcId")) {
            this.builder.vpcId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "hypervisor")) {
            this.builder.hypervisor(Hypervisor.fromValue(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "productCode")) {
            this.builder.productCode(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "instancesSet")) {
            this.inInstancesSet = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "placement")) {
            this.inPlacement = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "iamInstanceProfile")) {
            this.inIamInstanceProfile = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "ownerId")) {
            this.ownerId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "requesterId")) {
            this.requesterId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "reservationId")) {
            this.reservationId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "amiLaunchIndex")) {
            this.builder.amiLaunchIndex(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "dnsName")) {
            this.builder.dnsName(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "imageId")) {
            this.builder.imageId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "instanceId")) {
            this.builder.instanceId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "name")) {
            String rawState = SaxUtils.currentOrNull(this.currentText);
            this.builder.rawState(rawState);
            this.builder.instanceState(InstanceState.fromValue(rawState));
        } else if (SaxUtils.equalsOrSuffix(qName, "instanceType")) {
            this.builder.instanceType(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "ipAddress")) {
            this.builder.ipAddress(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "kernelId")) {
            this.builder.kernelId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "keyName")) {
            this.builder.keyName(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "launchTime")) {
            this.builder.launchTime(this.dateCodec.toDate(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "availabilityZone")) {
            this.builder.availabilityZone(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "virtualizationType")) {
            this.builder.virtualizationType(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "platform")) {
            this.builder.platform(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "privateDnsName")) {
            this.builder.privateDnsName(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "privateIpAddress")) {
            this.builder.privateIpAddress(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "ramdiskId")) {
            this.builder.ramdiskId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "reason")) {
            this.builder.reason(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "rootDeviceType")) {
            this.builder.rootDeviceType(RootDeviceType.fromValue(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "rootDeviceName")) {
            this.builder.rootDeviceName(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "deviceName")) {
            this.deviceName = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "volumeId")) {
            this.volumeId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "status")) {
            this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix(qName, "attachTime")) {
            this.attachTime = this.dateCodec.toDate(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "deleteOnTermination")) {
            this.deleteOnTermination = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix(qName, "ebs")) {
            this.builder.device(this.deviceName, new BlockDevice(this.volumeId, this.attachmentStatus, this.attachTime, this.deleteOnTermination));
            this.deviceName = null;
            this.volumeId = null;
            this.attachmentStatus = null;
            this.attachTime = null;
            this.deleteOnTermination = true;
        }
        this.currentText.setLength(0);
    }

    protected void inItem() {
        if (this.endOfInstanceItem()) {
            this.refineBuilderBeforeAddingInstance();
            this.instances.add(this.builder.build());
            this.builder = this.newBuilder();
        }
    }

    protected void refineBuilderBeforeAddingInstance() {
        String region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull(this.getRequest()) : null;
        this.builder.region(region == null ? this.defaultRegion.get() : region);
    }

    protected abstract boolean endOfInstanceItem();

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected Reservation<? extends RunningInstance> newReservation() {
        String region;
        String string = region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull(this.getRequest()) : null;
        if (region == null) {
            region = this.defaultRegion.get();
        }
        Reservation<RunningInstance> info = new Reservation<RunningInstance>(region, this.reservationGroupIdToNames.values(), this.instances, this.ownerId, this.requesterId, this.reservationId);
        this.reservationGroupIdToNames = Maps.newLinkedHashMap();
        this.instances = Sets.newLinkedHashSet();
        this.ownerId = null;
        this.requesterId = null;
        this.reservationId = null;
        return info;
    }
}

