/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.beans.ConstructorProperties;
import javax.inject.Named;

public class Package
implements Comparable<Package> {
    protected final String name;
    @Named(value="memory")
    protected final int memorySizeMb;
    @Named(value="disk")
    protected final int diskSizeGb;
    @Named(value="swap")
    protected final int swapSizeMb;
    @Named(value="default")
    protected final boolean isDefault;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromPackage(this);
    }

    @ConstructorProperties(value={"name", "memory", "disk", "swap", "default"})
    public Package(String name, int memorySizeMb, int diskSizeGb, int swapSizeMb, boolean isDefault) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.memorySizeMb = memorySizeMb;
        this.diskSizeGb = diskSizeGb;
        this.swapSizeMb = swapSizeMb;
        this.isDefault = isDefault;
    }

    public String getName() {
        return this.name;
    }

    public int getMemorySizeMb() {
        return this.memorySizeMb;
    }

    public int getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public int getSwapSizeMb() {
        return this.swapSizeMb;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Package) {
            Package that = (Package)Package.class.cast(object);
            return Objects.equal(this.name, that.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public String toString() {
        return Objects.toStringHelper("").omitNullValues().add("name", this.name).add("memorySizeMb", this.memorySizeMb).add("diskSizeGb", this.diskSizeGb).add("swapSizeMb", this.swapSizeMb).add("isDefault", this.isDefault).toString();
    }

    @Override
    public int compareTo(Package that) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.name), (Comparable<?>)((Object)that.name)).compare(this.memorySizeMb, that.memorySizeMb).compare(this.diskSizeGb, that.diskSizeGb).compare(this.swapSizeMb, that.swapSizeMb).result();
    }

    public static class Builder {
        private String name;
        private int memorySizeMb;
        private int diskSizeGb;
        private int swapSizeMb;
        private boolean isDefault;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder memorySizeMb(int memorySizeMb) {
            this.memorySizeMb = memorySizeMb;
            return this;
        }

        public Builder diskSizeGb(int diskSizeGb) {
            this.diskSizeGb = diskSizeGb;
            return this;
        }

        public Builder swapSizeMb(int swapSizeMb) {
            this.swapSizeMb = swapSizeMb;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Package build() {
            return new Package(this.name, this.memorySizeMb, this.diskSizeGb, this.swapSizeMb, this.isDefault);
        }

        public Builder fromPackage(Package in) {
            return this.name(in.getName()).memorySizeMb(in.getMemorySizeMb()).diskSizeGb(in.getDiskSizeGb()).swapSizeMb(in.getSwapSizeMb()).isDefault(in.isDefault());
        }
    }
}

