/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class LaunchSpecificationHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<LaunchSpecification> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final DateCodec dateCodec;
    protected final LaunchSpecification.Builder builder;
    protected final BlockDeviceMapping.Builder blockDeviceMappingBuilder;
    protected StringBuilder currentText = new StringBuilder();
    private boolean inBlockDeviceMapping;
    private boolean inIamInstanceProfile;
    private String groupId;

    @Inject
    public LaunchSpecificationHandler(DateCodecFactory dateCodecFactory, LaunchSpecification.Builder builder, BlockDeviceMapping.Builder blockDeviceMappingBuilder) {
        this.dateCodec = dateCodecFactory.iso8601();
        this.builder = builder;
        this.blockDeviceMappingBuilder = blockDeviceMappingBuilder;
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("blockDeviceMapping")) {
            this.inBlockDeviceMapping = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "iamInstanceProfile")) {
            this.inIamInstanceProfile = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String name, String qName) {
        String monitoringEnabled;
        if (qName.equals("blockDeviceMapping")) {
            this.inBlockDeviceMapping = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "iamInstanceProfile")) {
            this.inIamInstanceProfile = false;
        } else if (qName.equals("item") && this.inBlockDeviceMapping) {
            try {
                this.builder.blockDeviceMapping(this.blockDeviceMappingBuilder.build());
            }
            finally {
                this.blockDeviceMappingBuilder.clear();
            }
        } else if (SaxUtils.equalsOrSuffix(qName, "arn") && this.inIamInstanceProfile) {
            this.builder.iamInstanceProfileArn(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "name") && this.inIamInstanceProfile) {
            this.builder.iamInstanceProfileName(this.currentOrNull());
        } else if (qName.equals("deviceName")) {
            this.blockDeviceMappingBuilder.deviceName(this.currentOrNull());
        } else if (qName.equals("virtualName")) {
            this.blockDeviceMappingBuilder.virtualName(this.currentOrNull());
        } else if (qName.equals("snapshotId")) {
            this.blockDeviceMappingBuilder.snapshotId(this.currentOrNull());
        } else if (qName.equals("volumeSize")) {
            String volumeSize = this.currentOrNull();
            if (volumeSize != null) {
                this.blockDeviceMappingBuilder.sizeInGib(Integer.parseInt(volumeSize));
            }
        } else if (qName.equals("noDevice")) {
            String noDevice = this.currentOrNull();
            if (noDevice != null) {
                this.blockDeviceMappingBuilder.noDevice(Boolean.parseBoolean(noDevice));
            }
        } else if (qName.equals("deleteOnTermination")) {
            String deleteOnTermination = this.currentOrNull();
            if (deleteOnTermination != null) {
                this.blockDeviceMappingBuilder.deleteOnTermination(Boolean.parseBoolean(deleteOnTermination));
            }
        } else if (qName.equals("groupId")) {
            this.groupId = this.currentOrNull();
        } else if (qName.equals("groupName")) {
            this.builder.securityGroupIdToName(this.groupId, this.currentOrNull());
            this.groupId = null;
        } else if (qName.equals("imageId")) {
            this.builder.imageId(this.currentOrNull());
        } else if (qName.equals("instanceType")) {
            this.builder.instanceType(this.currentOrNull());
        } else if (qName.equals("kernelId")) {
            this.builder.kernelId(this.currentOrNull());
        } else if (qName.equals("keyName")) {
            this.builder.keyName(this.currentOrNull());
        } else if (qName.equals("availabilityZone")) {
            this.builder.availabilityZone(this.currentOrNull());
        } else if (qName.equals("subnetId")) {
            this.builder.subnetId(this.currentOrNull());
        } else if (qName.equals("ramdiskId")) {
            this.builder.ramdiskId(this.currentOrNull());
        } else if (qName.equals("enabled") && (monitoringEnabled = this.currentOrNull()) != null) {
            this.builder.monitoringEnabled(Boolean.valueOf(monitoringEnabled));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LaunchSpecification getResult() {
        try {
            LaunchSpecification launchSpecification = this.builder.build();
            return launchSpecification;
        }
        finally {
            this.builder.clear();
        }
    }
}

