/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class TemplateMetadata {
    private final String name;
    private final String osTypeId;
    private final String displayText;
    private final String snapshotId;
    private final String volumeId;
    private final String virtualMachineId;
    private final Boolean passwordEnabled;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromTemplateMetadata(this);
    }

    @ConstructorProperties(value={"name", "osTypeId", "displayText", "snapshotId", "volumeId", "virtualMachineId", "passwordEnabled"})
    protected TemplateMetadata(String name, @Nullable String osTypeId, @Nullable String displayText, @Nullable String snapshotId, @Nullable String volumeId, String virtualMachineId, Boolean passwordEnabled) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.osTypeId = osTypeId;
        this.displayText = displayText;
        this.snapshotId = snapshotId;
        this.volumeId = volumeId;
        this.virtualMachineId = virtualMachineId;
        this.passwordEnabled = passwordEnabled;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getOsTypeId() {
        return this.osTypeId;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    @Nullable
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public String getVolumeId() {
        return this.volumeId;
    }

    @Nullable
    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    @Nullable
    public Boolean isPasswordEnabled() {
        return this.passwordEnabled;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.osTypeId, this.displayText, this.snapshotId, this.volumeId, this.virtualMachineId, this.passwordEnabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateMetadata that = (TemplateMetadata)TemplateMetadata.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.osTypeId, that.osTypeId) && Objects.equal(this.displayText, that.displayText) && Objects.equal(this.snapshotId, that.snapshotId) && Objects.equal(this.volumeId, that.volumeId) && Objects.equal(this.virtualMachineId, that.virtualMachineId) && Objects.equal(this.passwordEnabled, that.passwordEnabled);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("name", this.name).add("osTypeId", this.osTypeId).add("displayText", this.displayText).add("snapshotId", this.snapshotId).add("volumeId", this.volumeId).add("virtualMachineId", this.virtualMachineId).add("passwordEnabled", this.passwordEnabled);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected String osTypeId;
        protected String displayText;
        protected String snapshotId;
        protected String volumeId;
        protected String virtualMachineId;
        protected Boolean passwordEnabled;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T osTypeId(String osTypeId) {
            this.osTypeId = osTypeId;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this.self();
        }

        public T volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this.self();
        }

        public T virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this.self();
        }

        public T passwordEnabled(Boolean passwordEnabled) {
            this.passwordEnabled = passwordEnabled;
            return this.self();
        }

        public TemplateMetadata build() {
            return new TemplateMetadata(this.name, this.osTypeId, this.displayText, this.snapshotId, this.volumeId, this.virtualMachineId, this.passwordEnabled);
        }

        public T fromTemplateMetadata(TemplateMetadata in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.name(in.getName())).osTypeId(in.getOsTypeId())).displayText(in.getDisplayText())).snapshotId(in.getSnapshotId())).volumeId(in.getVolumeId())).virtualMachineId(in.getVirtualMachineId())).passwordEnabled(in.isPasswordEnabled());
        }
    }
}

