/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class CreateTagsOptions
extends BaseHttpRequestOptions {
    public static final CreateTagsOptions NONE = new CreateTagsOptions();

    public CreateTagsOptions customer(String customer) {
        this.queryParameters.replaceValues("customer", ImmutableSet.of(customer));
        return this;
    }

    public CreateTagsOptions resourceIds(Set<String> resourceIds) {
        this.queryParameters.replaceValues("resourceids", ImmutableSet.of(Joiner.on(",").join(resourceIds)));
        return this;
    }

    public CreateTagsOptions resourceIds(String ... resourceIds) {
        this.queryParameters.replaceValues("resourceids", ImmutableSet.of(Joiner.on(",").join(resourceIds)));
        return this;
    }

    public CreateTagsOptions resourceType(String resourceType) {
        this.queryParameters.replaceValues("resourcetype", ImmutableSet.of(resourceType));
        return this;
    }

    public CreateTagsOptions resourceType(Tag.ResourceType resourceType) {
        this.queryParameters.replaceValues("resourcetype", ImmutableSet.of(resourceType.toString()));
        return this;
    }

    public CreateTagsOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues(String.format("tags[%d].key", count), ImmutableSet.of(entry.getKey()));
            this.queryParameters.replaceValues(String.format("tags[%d].value", count), ImmutableSet.of(entry.getValue()));
            ++count;
        }
        return this;
    }

    public static class Builder {
        public static CreateTagsOptions customer(String customer) {
            CreateTagsOptions options = new CreateTagsOptions();
            return options.customer(customer);
        }

        public static CreateTagsOptions resourceIds(Set<String> resourceIds) {
            CreateTagsOptions options = new CreateTagsOptions();
            return options.resourceIds(resourceIds);
        }

        public static CreateTagsOptions resourceIds(String ... resourceIds) {
            CreateTagsOptions options = new CreateTagsOptions();
            return options.resourceIds(resourceIds);
        }

        public static CreateTagsOptions resourceType(String resourceType) {
            CreateTagsOptions options = new CreateTagsOptions();
            return options.resourceType(resourceType);
        }

        public static CreateTagsOptions resourceType(Tag.ResourceType resourceType) {
            CreateTagsOptions options = new CreateTagsOptions();
            return options.resourceType(resourceType);
        }

        public static CreateTagsOptions tags(Map<String, String> tags) {
            CreateTagsOptions options = new CreateTagsOptions();
            return options.tags(tags);
        }
    }
}

