/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import java.util.Map;
import javax.inject.Inject;
import org.jclouds.ec2.domain.Subnet;
import org.jclouds.ec2.xml.TagSetHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class SubnetHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Subnet> {
    private StringBuilder currentText = new StringBuilder();
    private Subnet.Builder builder = Subnet.builder();
    private final TagSetHandler tagSetHandler;
    private boolean inTagSet;

    @Inject
    public SubnetHandler(TagSetHandler tagSetHandler) {
        this.tagSetHandler = tagSetHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subnet getResult() {
        try {
            Subnet subnet = this.builder.build();
            return subnet;
        }
        finally {
            this.builder = Subnet.builder();
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = true;
        }
        if (this.inTagSet) {
            this.tagSetHandler.startElement(uri, name, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
            this.builder.tags((Map<String, String>)this.tagSetHandler.getResult());
        } else if (this.inTagSet) {
            this.tagSetHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "subnetId")) {
            this.builder.subnetId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "state")) {
            this.builder.subnetState(Subnet.State.fromValue(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "vpcId")) {
            this.builder.vpcId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "cidrBlock")) {
            this.builder.cidrBlock(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "availableIpAddressCount")) {
            this.builder.availableIpAddressCount(Integer.parseInt(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "availabilityZone")) {
            this.builder.availabilityZone(SaxUtils.currentOrNull(this.currentText));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inTagSet) {
            this.tagSetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

