/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.domain.Credentials;

public final class SessionCredentials
extends Credentials {
    private final String sessionToken;
    private final Optional<Date> expiration;

    private SessionCredentials(String accessKeyId, String secretAccessKey, String sessionToken, Optional<Date> expiration) {
        super(Preconditions.checkNotNull(accessKeyId, "accessKeyId"), Preconditions.checkNotNull(secretAccessKey, "secretAccessKey for %s", accessKeyId));
        this.sessionToken = Preconditions.checkNotNull(sessionToken, "sessionToken for %s", accessKeyId);
        this.expiration = Preconditions.checkNotNull(expiration, "expiration for %s", accessKeyId);
    }

    public String getAccessKeyId() {
        return this.identity;
    }

    public String getSecretAccessKey() {
        return this.credential;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public Optional<Date> getExpiration() {
        return this.expiration;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.identity, this.credential, this.sessionToken, this.expiration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionCredentials other = (SessionCredentials)obj;
        return Objects.equal(this.identity, other.identity) && Objects.equal(this.credential, other.credential) && Objects.equal(this.sessionToken, other.sessionToken) && Objects.equal(this.expiration, other.expiration);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("accessKeyId", this.identity).add("sessionToken", this.sessionToken).add("expiration", this.expiration.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SessionCredentials.builder().from(this);
    }

    public static final class Builder
    extends Credentials.Builder<SessionCredentials> {
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;
        private Optional<Date> expiration = Optional.absent();

        public Builder identity(String identity) {
            return this.accessKeyId(identity);
        }

        public Builder credential(String credential) {
            return this.secretAccessKey(credential);
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public Builder expiration(Date expiration) {
            this.expiration = Optional.fromNullable(expiration);
            return this;
        }

        @Override
        public SessionCredentials build() {
            return new SessionCredentials(this.accessKeyId, this.secretAccessKey, this.sessionToken, this.expiration);
        }

        public Builder from(SessionCredentials in) {
            return this.accessKeyId(in.identity).secretAccessKey(in.credential).sessionToken(in.sessionToken).expiration((Date)in.expiration.orNull());
        }
    }
}

