/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.eventbus.EventBus;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.jclouds.compute.callables.ScriptStillRunningException;
import org.jclouds.compute.callables.SudoAwareInitManager;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.events.StatementOnNodeCompletion;
import org.jclouds.compute.events.StatementOnNodeFailure;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

public class BlockUntilInitScriptStatusIsZeroThenReturnOutput
extends AbstractFuture<ExecResponse>
implements Runnable {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ListeningExecutorService userExecutor;
    private final EventBus eventBus;
    private final SudoAwareInitManager commandRunner;
    private Predicate<String> notRunningAnymore;

    public SudoAwareInitManager getCommandRunner() {
        return this.commandRunner;
    }

    @Inject
    public BlockUntilInitScriptStatusIsZeroThenReturnOutput(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, EventBus eventBus, ComputeServiceConstants.InitStatusProperties properties, @Assisted SudoAwareInitManager commandRunner) {
        this(userExecutor, eventBus, Predicates.alwaysTrue(), commandRunner);
        this.notRunningAnymore = BlockUntilInitScriptStatusIsZeroThenReturnOutput.loopUntilTrueOrThrowCancellationException(new ExitStatusOfCommandGreaterThanZero(commandRunner), properties.initStatusMaxPeriod, properties.initStatusInitialPeriod, this);
    }

    @VisibleForTesting
    public BlockUntilInitScriptStatusIsZeroThenReturnOutput(ListeningExecutorService userExecutor, EventBus eventBus, Predicate<String> notRunningAnymore, SudoAwareInitManager commandRunner) {
        this.commandRunner = Preconditions.checkNotNull(commandRunner, "commandRunner");
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecutor");
        this.eventBus = Preconditions.checkNotNull(eventBus, "eventBus");
        this.notRunningAnymore = Preconditions.checkNotNull(notRunningAnymore, "notRunningAnymore");
    }

    static Predicate<String> loopUntilTrueOrThrowCancellationException(Predicate<String> predicate, long period, long maxPeriod, final AbstractFuture<ExecResponse> futureWhichMightBeCancelled) {
        return Predicates2.retry(Predicates.and(predicate, new Predicate<String>(){

            @Override
            public boolean apply(String in) {
                if (futureWhichMightBeCancelled.isCancelled()) {
                    throw new CancellationException(futureWhichMightBeCancelled + " is cancelled");
                }
                return true;
            }
        }), period, maxPeriod, TimeUnit.MILLISECONDS);
    }

    public BlockUntilInitScriptStatusIsZeroThenReturnOutput init() {
        this.userExecutor.submit(this);
        return this;
    }

    @Override
    public void run() {
        try {
            ExecResponse exec = null;
            do {
                this.notRunningAnymore.apply("status");
                String stdout = this.commandRunner.runAction("stdout").getOutput();
                String stderr = this.commandRunner.runAction("stderr").getOutput();
                Integer exitStatus = Ints.tryParse(this.commandRunner.runAction("exitstatus").getOutput().trim());
                exec = new ExecResponse(stdout, stderr, exitStatus == null ? -1 : exitStatus);
            } while (!this.isCancelled() && exec.getExitStatus() == -1);
            this.logger.debug("<< complete(%s) status(%s)", this.commandRunner.getStatement().getInstanceName(), exec.getExitStatus());
            this.set(exec);
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    @Override
    protected boolean set(ExecResponse value) {
        this.eventBus.post(new StatementOnNodeCompletion(this.getCommandRunner().getStatement(), this.getCommandRunner().getNode(), value));
        return super.set(value);
    }

    @Override
    protected void interruptTask() {
        this.logger.debug("<< cancelled(%s)", this.commandRunner.getStatement().getInstanceName());
        ExecResponse returnVal = this.commandRunner.refreshAndRunAction("stop");
        CancellationException e = new CancellationException(String.format("cancelled %s on node: %s; stop command had exit status: %s", this.getCommandRunner().getStatement().getInstanceName(), this.getCommandRunner().getNode().getId(), returnVal));
        this.eventBus.post(new StatementOnNodeFailure(this.getCommandRunner().getStatement(), this.getCommandRunner().getNode(), e));
        super.interruptTask();
    }

    public String toString() {
        return Objects.toStringHelper(this).add("commandRunner", this.commandRunner).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.commandRunner);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        BlockUntilInitScriptStatusIsZeroThenReturnOutput that = (BlockUntilInitScriptStatusIsZeroThenReturnOutput)BlockUntilInitScriptStatusIsZeroThenReturnOutput.class.cast(o);
        return Objects.equal(this.commandRunner, that.commandRunner);
    }

    @Override
    public ExecResponse get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        try {
            return (ExecResponse)super.get(timeout, unit);
        }
        catch (TimeoutException e) {
            ScriptStillRunningException exception = new ScriptStillRunningException(timeout, unit, this);
            exception.initCause(e);
            throw exception;
        }
    }

    @VisibleForTesting
    static class ExitStatusOfCommandGreaterThanZero
    implements Predicate<String> {
        private final SudoAwareInitManager commandRunner;

        ExitStatusOfCommandGreaterThanZero(SudoAwareInitManager commandRunner) {
            this.commandRunner = commandRunner;
        }

        @Override
        public boolean apply(String input) {
            return this.commandRunner.runAction(input).getExitStatus() > 0;
        }
    }

    public static interface Factory {
        public BlockUntilInitScriptStatusIsZeroThenReturnOutput create(SudoAwareInitManager var1);
    }
}

