/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.StandardDrive;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.elasticstack.functions.MapToStandardDrive;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class ListOfKeyValuesDelimitedByBlankLinesToStandardDriveSet
implements Function<HttpResponse, Set<StandardDrive>> {
    private final ReturnStringIf2xx returnStringIf2xx;
    private final ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter;
    private final MapToStandardDrive mapToStandardDrive;

    @Inject
    ListOfKeyValuesDelimitedByBlankLinesToStandardDriveSet(ReturnStringIf2xx returnStringIf2xx, ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter, MapToStandardDrive mapToStandardDrive) {
        this.returnStringIf2xx = Preconditions.checkNotNull(returnStringIf2xx, "returnStringIf2xx");
        this.mapConverter = Preconditions.checkNotNull(mapConverter, "mapConverter");
        this.mapToStandardDrive = Preconditions.checkNotNull(mapToStandardDrive, "mapToStandardDrive");
    }

    @Override
    public Set<StandardDrive> apply(HttpResponse response) {
        String text = Strings.nullToEmpty(this.returnStringIf2xx.apply(response));
        if (text.trim().equals("")) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(Iterables.transform(this.mapConverter.apply(text), this.mapToStandardDrive));
    }
}

