/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.ovf.Disk;
import org.jclouds.ovf.Section;

public class DiskSection
extends Section<DiskSection> {
    private final Set<Disk> disks;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromDiskSection(this);
    }

    public DiskSection(String info, Iterable<Disk> disks) {
        super(info);
        this.disks = ImmutableSet.copyOf(Preconditions.checkNotNull(disks, "disks"));
    }

    public Set<Disk> getDisks() {
        return this.disks;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.disks == null ? 0 : this.disks.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiskSection other = (DiskSection)obj;
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        return !(this.disks == null ? other.disks != null : !this.disks.equals(other.disks));
    }

    @Override
    public String toString() {
        return String.format("[info=%s, disks=%s]", this.info, this.disks);
    }

    public static class Builder
    extends Section.Builder<DiskSection> {
        protected Set<Disk> disks = Sets.newLinkedHashSet();

        public Builder disk(Disk disk) {
            this.disks.add(Preconditions.checkNotNull(disk, "disk"));
            return this;
        }

        public Builder disks(Iterable<Disk> disks) {
            this.disks = ImmutableSet.copyOf(Preconditions.checkNotNull(disks, "disks"));
            return this;
        }

        public DiskSection build() {
            return new DiskSection(this.info, this.disks);
        }

        public Builder fromDiskSection(DiskSection in) {
            return this.disks(in.getDisks()).info(in.getInfo());
        }

        public Builder fromSection(Section<DiskSection> in) {
            return (Builder)super.fromSection(in);
        }

        public Builder info(String info) {
            return (Builder)super.info(info);
        }
    }
}

