/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.variables;

import java.util.Map;
import org.nnsoft.guice.rocoto.variables.AbstractAppender;
import org.nnsoft.guice.rocoto.variables.Appender;
import org.nnsoft.guice.rocoto.variables.Parser;
import org.nnsoft.guice.rocoto.variables.Resolver;
import org.nnsoft.guice.rocoto.variables.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class KeyAppender
extends AbstractAppender {
    private final Appender key;
    private Appender defaultValue;
    private Parser parser;

    public KeyAppender(Parser parser, String chunk, Appender key) {
        this(parser, chunk, key, null);
    }

    public KeyAppender(Parser parser, String chunk, Appender key, Appender defaultValue) {
        super(chunk);
        this.parser = parser;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    public void doAppend(StringBuilder buffer, Map<String, String> configuration, Tree<Appender> context) {
        StringBuilder keyBuffer = new StringBuilder();
        this.key.append(keyBuffer, configuration, context);
        String resolvedKey = keyBuffer.toString();
        String resolvedValue = configuration.get(resolvedKey);
        if (resolvedValue != null) {
            Resolver value = this.parser.parse(resolvedValue);
            if (!value.needsResolving()) {
                buffer.append(resolvedValue);
            } else {
                if (!(value instanceof Appender)) {
                    resolvedValue = value.resolve(configuration);
                } else {
                    StringBuilder resolvedValueBuffer = new StringBuilder();
                    ((Appender)value).append(resolvedValueBuffer, configuration, context);
                    resolvedValue = resolvedValueBuffer.toString();
                }
                buffer.append(resolvedValue);
                configuration.put(resolvedKey, resolvedValue);
            }
        } else if (this.defaultValue != null) {
            this.defaultValue.append(buffer, configuration, context);
        } else {
            buffer.append(this.chunk);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof KeyAppender) {
            KeyAppender other = (KeyAppender)obj;
            return (this.key != null ? this.key.equals(other.key) : other.key == null) && (this.defaultValue != null ? this.defaultValue.equals(other.defaultValue) : other.defaultValue == null);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.key != null ? this.key.hashCode() : 0) + (this.defaultValue != null ? this.defaultValue.hashCode() * 31 : 0);
    }

    @Override
    public boolean needsResolving() {
        return true;
    }
}

