/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.PresentInstances;
import org.jclouds.ec2.domain.RunningInstance;

@Singleton
public class PresentSpotRequestsAndInstances
extends PresentInstances {
    private final AWSEC2Api client;
    private final Function<SpotInstanceRequest, AWSRunningInstance> spotConverter;

    @Inject
    public PresentSpotRequestsAndInstances(AWSEC2Api client, Function<SpotInstanceRequest, AWSRunningInstance> spotConverter) {
        super(client);
        this.client = Preconditions.checkNotNull(client, "client");
        this.spotConverter = Preconditions.checkNotNull(spotConverter, "spotConverter");
    }

    @Override
    public Set<RunningInstance> apply(Set<RegionAndName> regionAndIds) {
        if (Preconditions.checkNotNull(regionAndIds, "regionAndIds").isEmpty()) {
            return ImmutableSet.of();
        }
        if (Iterables.any(regionAndIds, Predicates.compose(Predicates.containsPattern("sir-"), RegionAndName.nameFunction()))) {
            return this.getSpots(regionAndIds);
        }
        return super.apply(regionAndIds);
    }

    protected Set<RunningInstance> getSpots(Set<RegionAndName> regionAndIds) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ListMultimap<String, String> regionToSpotIds = Multimaps.transformValues(Multimaps.index(regionAndIds, RegionAndName.regionFunction()), RegionAndName.nameFunction());
        for (Map.Entry entry : regionToSpotIds.asMap().entrySet()) {
            String region = (String)entry.getKey();
            Collection spotIds = entry.getValue();
            this.logger.trace("looking for spots %s in region %s", spotIds, region);
            builder.addAll(Iterables.transform(this.client.getSpotInstanceApi().get().describeSpotInstanceRequestsInRegion(region, Iterables.toArray(spotIds, String.class)), this.spotConverter));
        }
        return builder.build();
    }

    @Override
    public String toString() {
        return "presentSpotRequestsAndInstances()";
    }
}

