/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.features.AddressApi;
import org.jclouds.cloudstack.options.AssociateIPAddressOptions;
import org.jclouds.cloudstack.options.ListPublicIPAddressesOptions;
import org.jclouds.cloudstack.predicates.PublicIPAddressPredicates;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.logging.Logger;

@Singleton
public class ReuseOrAssociateNewPublicIPAddress
implements Function<Network, PublicIPAddress> {
    private final CloudStackApi client;
    private final BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    public ReuseOrAssociateNewPublicIPAddress(CloudStackApi client, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.blockUntilJobCompletesAndReturnResult = Preconditions.checkNotNull(blockUntilJobCompletesAndReturnResult, "blockUntilJobCompletesAndReturnResult");
    }

    public static PublicIPAddress findAvailableAndAssociatedWithNetwork(String networkId, AddressApi client) {
        return Iterables.find(client.listPublicIPAddresses(ListPublicIPAddressesOptions.Builder.allocatedOnly(true).networkId(networkId)), Predicates.and(PublicIPAddressPredicates.associatedWithNetwork(networkId), PublicIPAddressPredicates.available()));
    }

    public static PublicIPAddress associateIPAddressInNetwork(Network network, CloudStackApi client, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult) {
        AsyncCreateResponse job = client.getAddressApi().associateIPAddressInZone(network.getZoneId(), AssociateIPAddressOptions.Builder.networkId(network.getId()));
        PublicIPAddress ip = (PublicIPAddress)blockUntilJobCompletesAndReturnResult.apply(job);
        assert (ip.getZoneId().equals(network.getZoneId()));
        return ip;
    }

    @Override
    public PublicIPAddress apply(Network input) {
        try {
            this.logger.debug(">> looking for existing address in network(%s)", input.getId());
            PublicIPAddress returnVal = ReuseOrAssociateNewPublicIPAddress.findAvailableAndAssociatedWithNetwork(input.getId(), this.client.getAddressApi());
            this.logger.debug("<< reused address(%s)", returnVal.getId());
            return returnVal;
        }
        catch (NoSuchElementException e) {
            this.logger.debug(">> associating new address in network(%s)", input.getId());
            PublicIPAddress returnVal = ReuseOrAssociateNewPublicIPAddress.associateIPAddressInNetwork(input, this.client, this.blockUntilJobCompletesAndReturnResult);
            this.logger.debug("<< associated address(%s)", returnVal.getId());
            return returnVal;
        }
    }
}

