/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeMetadataBuilder;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.internal.NodeMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public class NodeMetadataBuilder
extends ComputeMetadataBuilder {
    private NodeMetadata.Status status;
    private String backendStatus;
    private Set<String> publicAddresses = Sets.newLinkedHashSet();
    private Set<String> privateAddresses = Sets.newLinkedHashSet();
    @Nullable
    private LoginCredentials credentials;
    @Nullable
    private String group;
    private int loginPort = 22;
    @Nullable
    private String imageId;
    @Nullable
    private Hardware hardware;
    @Nullable
    private OperatingSystem os;
    @Nullable
    private String hostname;

    public NodeMetadataBuilder() {
        super(ComputeType.NODE);
    }

    public NodeMetadataBuilder loginPort(int loginPort) {
        this.loginPort = loginPort;
        return this;
    }

    public NodeMetadataBuilder status(NodeMetadata.Status status) {
        this.status = Preconditions.checkNotNull(status, "status");
        return this;
    }

    public NodeMetadataBuilder backendStatus(@Nullable String backendStatus) {
        this.backendStatus = backendStatus;
        return this;
    }

    public NodeMetadataBuilder publicAddresses(Iterable<String> publicAddresses) {
        this.publicAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(publicAddresses, "publicAddresses"));
        return this;
    }

    public NodeMetadataBuilder privateAddresses(Iterable<String> privateAddresses) {
        this.privateAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(privateAddresses, "privateAddresses"));
        return this;
    }

    public NodeMetadataBuilder credentials(@Nullable LoginCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public NodeMetadataBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public NodeMetadataBuilder imageId(@Nullable String imageId) {
        this.imageId = imageId;
        return this;
    }

    public NodeMetadataBuilder hardware(@Nullable Hardware hardware) {
        this.hardware = hardware;
        return this;
    }

    public NodeMetadataBuilder operatingSystem(@Nullable OperatingSystem os) {
        this.os = os;
        return this;
    }

    public NodeMetadataBuilder hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Override
    public NodeMetadataBuilder id(String id) {
        return (NodeMetadataBuilder)NodeMetadataBuilder.class.cast(super.id(id));
    }

    @Override
    public NodeMetadataBuilder tags(Iterable<String> tags) {
        return (NodeMetadataBuilder)NodeMetadataBuilder.class.cast(super.tags(tags));
    }

    @Override
    public NodeMetadataBuilder ids(String id) {
        return (NodeMetadataBuilder)NodeMetadataBuilder.class.cast(super.ids(id));
    }

    @Override
    public NodeMetadataBuilder providerId(String providerId) {
        return (NodeMetadataBuilder)NodeMetadataBuilder.class.cast(super.providerId(providerId));
    }

    @Override
    public NodeMetadataBuilder name(String name) {
        return (NodeMetadataBuilder)NodeMetadataBuilder.class.cast(super.name(name));
    }

    @Override
    public NodeMetadataBuilder location(Location location) {
        return (NodeMetadataBuilder)NodeMetadataBuilder.class.cast(super.location(location));
    }

    @Override
    public NodeMetadataBuilder uri(URI uri) {
        return (NodeMetadataBuilder)NodeMetadataBuilder.class.cast(super.uri(uri));
    }

    @Override
    public NodeMetadataBuilder userMetadata(Map<String, String> userMetadata) {
        return (NodeMetadataBuilder)NodeMetadataBuilder.class.cast(super.userMetadata((Map)userMetadata));
    }

    @Override
    public NodeMetadata build() {
        return new NodeMetadataImpl(this.providerId, this.name, this.id, this.location, this.uri, this.userMetadata, this.tags, this.group, this.hardware, this.imageId, this.os, this.status, this.backendStatus, this.loginPort, this.publicAddresses, this.privateAddresses, this.credentials, this.hostname);
    }

    public static NodeMetadataBuilder fromNodeMetadata(NodeMetadata node) {
        return ((NodeMetadataBuilder)((NodeMetadataBuilder)new NodeMetadataBuilder().providerId(node.getProviderId()).name(node.getName()).id(node.getId()).location(node.getLocation()).uri(node.getUri()).userMetadata((Map)node.getUserMetadata())).tags(node.getTags())).group(node.getGroup()).hardware(node.getHardware()).imageId(node.getImageId()).operatingSystem(node.getOperatingSystem()).status((NodeMetadata.Status)((Object)node.getStatus())).backendStatus(node.getBackendStatus()).loginPort(node.getLoginPort()).publicAddresses(node.getPublicAddresses()).privateAddresses(node.getPrivateAddresses()).credentials(node.getCredentials()).hostname(node.getHostname());
    }
}

