/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import org.jclouds.Fallback;
import org.jclouds.aws.AWSResponseException;

public final class EC2Fallbacks {
    private EC2Fallbacks() {
    }

    public static final class VoidOnVolumeAvailable
    implements Fallback<Void> {
        @Override
        public Void createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull(t, "throwable") instanceof AWSResponseException) {
                AWSResponseException e = (AWSResponseException)AWSResponseException.class.cast(t);
                if (Predicates.in(ImmutableSet.of("IncorrectState", "available")).apply(e.getError().getCode())) {
                    return null;
                }
            }
            throw Throwables.propagate(t);
        }
    }
}

